/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;

@API(since="0.5.6", status=API.Status.MAINTAINED)
public final class MapEntryIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final Matcher MATCHER = new AssignableTypeMatcher(Map.Entry.class);

    @Override
    public boolean match(Property property) {
        return MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        if (!property.isContainer()) {
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        List<CombinableArbitrary<?>> elementCombinableArbitraryList = context.getElementCombinableArbitraryList();
        if (elementCombinableArbitraryList.size() != 1) {
            throw new IllegalArgumentException("Map entry node should have only one child, current : " + elementCombinableArbitraryList.size());
        }
        return new ArbitraryIntrospectorResult(CombinableArbitrary.containerBuilder().elements(elementCombinableArbitraryList).postBuild(() -> context.evictUnique(context.getPropertyPath())).build(MapEntryIntrospector::combine));
    }

    private static Object combine(List<Object> elements) {
        MapEntryElementProperty.MapEntryElementType mapEntryElementType = (MapEntryElementProperty.MapEntryElementType)elements.get(0);
        return new AbstractMap.SimpleEntry<Object, Object>(mapEntryElementType.getKey(), mapEntryElementType.getValue());
    }
}

