/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class SetIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final Matcher MATCHER = new AssignableTypeMatcher(Set.class);

    @Override
    public boolean match(Property property) {
        return MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty arbitraryProperty = context.getArbitraryProperty();
        if (!arbitraryProperty.isContainer()) {
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        List<CombinableArbitrary<?>> elementArbitraryList = context.getElementCombinableArbitraryList().stream().map(it -> it.filter(context.getGenerateUniqueMaxTries(), element -> context.isUniqueAndCheck(context.getPropertyPath(), element))).collect(Collectors.toList());
        return new ArbitraryIntrospectorResult(CombinableArbitrary.containerBuilder().elements(elementArbitraryList).postBuild(() -> context.evictUnique(context.getPropertyPath())).build(HashSet::new));
    }
}

