/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.Arrays;
import java.util.List;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class StreamIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final List<Matcher> MATCHERS = Arrays.asList(new AssignableTypeMatcher(Stream.class), new AssignableTypeMatcher(IntStream.class), new AssignableTypeMatcher(LongStream.class), new AssignableTypeMatcher(DoubleStream.class));

    @Override
    public boolean match(Property property) {
        return MATCHERS.stream().anyMatch(it -> it.match(property));
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        if (!property.isContainer()) {
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        return new ArbitraryIntrospectorResult(CombinableArbitrary.containerBuilder().elements(context.getElementCombinableArbitraryList()).build(this::combine));
    }

    private Object combine(List<Object> elements) {
        Stream.Builder<Object> builder = Stream.builder();
        for (Object element : elements) {
            builder = builder.add(element);
        }
        return builder.build();
    }
}

