/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.2", status=API.Status.MAINTAINED)
public final class ConstructorProperty
implements Property {
    private final AnnotatedType annotatedType;
    private final Constructor<?> constructor;
    private final String parameterName;
    @Nullable
    private final Property fieldProperty;
    private final List<Annotation> annotations;
    private final Map<Class<? extends Annotation>, Annotation> annotationsMap;
    @Nullable
    private final Boolean nullable;

    public ConstructorProperty(AnnotatedType annotatedType, Constructor<?> constructor, String parameterName, @Nullable Property fieldProperty, @Nullable Boolean nullable) {
        this.annotatedType = annotatedType;
        this.constructor = constructor;
        this.parameterName = parameterName;
        this.fieldProperty = fieldProperty;
        this.annotations = Arrays.asList(annotatedType.getAnnotations());
        this.annotationsMap = this.annotations.stream().collect(Collectors.toMap(Annotation::annotationType, Function.identity(), (a1, a2) -> a1));
        this.nullable = nullable;
    }

    @Override
    public Type getType() {
        return this.getAnnotatedType().getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    @Nullable
    public Property getFieldProperty() {
        return this.fieldProperty;
    }

    @Override
    public String getName() {
        return this.parameterName;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationClass) {
        return Optional.ofNullable(this.annotationsMap.get(annotationClass)).map(annotationClass::cast);
    }

    @Override
    @Nullable
    public Boolean isNullable() {
        return this.nullable;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstructorProperty that = (ConstructorProperty)obj;
        return this.annotatedType.equals(that.annotatedType) && this.constructor.equals(that.constructor) && this.parameterName.equals(that.parameterName) && Objects.equals(this.fieldProperty, that.fieldProperty) && this.annotations.equals(that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.annotatedType, this.constructor, this.parameterName, this.fieldProperty, this.annotations);
    }

    @Override
    @Nullable
    public Object getValue(Object instance) {
        if (this.fieldProperty != null) {
            return this.fieldProperty.getValue(instance);
        }
        return null;
    }

    public String toString() {
        return "ConstructorProperty{annotatedType=" + this.annotatedType + ", constructor=" + this.constructor + ", parameterName='" + this.parameterName + '\'' + ", fieldProperty=" + this.fieldProperty + '}';
    }
}

