/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@API(since="0.6.10", status=API.Status.MAINTAINED)
public abstract class AnnotatedTypes {
    public static AnnotatedArrayType newAnnotatedArrayType(final AnnotatedType annotatedGenericComponentType, final Type type, final Annotation[] annotations, final Annotation[] declaredAnnotations, AnnotatedType annotatedOwnerType) {
        return new AnnotatedArrayType(){

            @Override
            public AnnotatedType getAnnotatedGenericComponentType() {
                return annotatedGenericComponentType;
            }

            @Override
            public Type getType() {
                return type;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)((Annotation)Arrays.stream(annotations).filter(it -> it.getClass() == annotationClass).findAny().map(annotationClass::cast).orElse(null));
            }

            @Override
            public Annotation[] getAnnotations() {
                return annotations;
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return declaredAnnotations;
            }
        };
    }

    public static AnnotatedParameterizedType newAnnotatedParameterizedType(final AnnotatedType[] annotatedActualTypeArguments, final Type type, final Annotation[] annotations, final Annotation[] declaredAnnotations, AnnotatedType annotatedOwnerType) {
        return new AnnotatedParameterizedType(){

            @Override
            public AnnotatedType[] getAnnotatedActualTypeArguments() {
                return annotatedActualTypeArguments;
            }

            @Override
            public Type getType() {
                return type;
            }

            @Override
            @Nullable
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)((Annotation)Arrays.stream(annotations).filter(it -> it.getClass() == annotationClass).findAny().orElse(null));
            }

            @Override
            public Annotation[] getAnnotations() {
                return annotations;
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return declaredAnnotations;
            }
        };
    }

    public static AnnotatedTypeVariable newAnnotatedTypeVariable(final AnnotatedType currentAnnotatedType, final List<AnnotatedType> genericsAnnotatedTypes) {
        return new AnnotatedTypeVariable(){

            @Override
            public AnnotatedType[] getAnnotatedBounds() {
                AnnotatedType[] annotatedTypes = new AnnotatedType[]{(AnnotatedType)genericsAnnotatedTypes.get(0)};
                return annotatedTypes;
            }

            @Override
            public Type getType() {
                return ((AnnotatedType)genericsAnnotatedTypes.get(0)).getType();
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return currentAnnotatedType.getAnnotation(annotationClass);
            }

            @Override
            public Annotation[] getAnnotations() {
                return currentAnnotatedType.getAnnotations();
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return currentAnnotatedType.getDeclaredAnnotations();
            }
        };
    }
}

