/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.type;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class Reflections {
    public static <T> T newInstance(Class<T> clazz) {
        try {
            return Reflections.newInstance(clazz.getDeclaredConstructor(new Class[0]), new Object[0]);
        }
        catch (Throwable t) {
            throw Reflections.throwAsUnchecked(t);
        }
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return method.invoke(target, args);
        }
        catch (Throwable t) {
            throw Reflections.throwAsUnchecked(t);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        try {
            return constructor.newInstance(args);
        }
        catch (Throwable t) {
            throw Reflections.throwAsUnchecked(t);
        }
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods();
            for (Method method : methods) {
                if (!Reflections.isTargetMethod(method, methodName, parameterTypes)) continue;
                return method;
            }
            for (GenericDeclaration genericDeclaration : searchType.getInterfaces()) {
                Method interfaceMethod = Reflections.findMethod(genericDeclaration, methodName, parameterTypes);
                if (interfaceMethod == null) continue;
                return interfaceMethod;
            }
        }
        return null;
    }

    public static List<Field> findFields(Class<?> clazz) {
        return Reflections.findDeclaredFields(clazz);
    }

    private static boolean isTargetMethod(Method method, String methodName, Class<?>[] parameterTypes) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        if (method.getParameterCount() != parameterTypes.length) {
            return false;
        }
        return Arrays.equals(method.getParameterTypes(), parameterTypes);
    }

    private static List<Field> findDeclaredFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>(Reflections.getSuperclassFields(clazz));
        result.addAll(Reflections.getInterfaceFields(clazz));
        List localFields = Arrays.stream(clazz.getDeclaredFields()).filter(field -> !field.isSynthetic()).collect(Collectors.toList());
        result.addAll(localFields);
        return Reflections.toUniqueFieldNameList(result);
    }

    private static List<Field> getSuperclassFields(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null || superclass == Object.class) {
            return Collections.emptyList();
        }
        return Reflections.findDeclaredFields(superclass);
    }

    private static List<Field> getInterfaceFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            List<Field> localInterfaceFields = Arrays.asList(interfaceClass.getFields());
            List<Field> superinterfaceFields = Reflections.getInterfaceFields(interfaceClass);
            result.addAll(superinterfaceFields);
            result.addAll(localInterfaceFields);
        }
        return Reflections.toUniqueFieldNameList(result);
    }

    private static RuntimeException throwAsUnchecked(Throwable throwable) {
        Reflections.throwSelf(throwable);
        return new RuntimeException(throwable);
    }

    private static <T extends Throwable> void throwSelf(Throwable throwable) throws T {
        throw throwable;
    }

    private static List<Field> toUniqueFieldNameList(List<Field> fields) {
        return fields.stream().filter(Reflections.distinctByKey(Field::getName)).collect(Collectors.toList());
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }
}

