/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.container;

import com.navercorp.fixturemonkey.api.container.DecomposableJavaContainer;
import com.navercorp.fixturemonkey.api.container.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.api.container.IteratorCache;
import com.navercorp.fixturemonkey.api.container.StreamCache;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(since="0.6.0", status=API.Status.MAINTAINED)
public final class DefaultDecomposedContainerValueFactory
implements DecomposedContainerValueFactory {
    private final DecomposedContainerValueFactory additionalDecomposedContainerValueFactory;

    public DefaultDecomposedContainerValueFactory(DecomposedContainerValueFactory additionalDecomposedContainerValueFactory) {
        this.additionalDecomposedContainerValueFactory = additionalDecomposedContainerValueFactory;
    }

    @Override
    public DecomposableJavaContainer from(Object container) {
        Class<?> actualType = container.getClass();
        if (Iterable.class.isAssignableFrom(actualType)) {
            Iterator iterator = ((Iterable)container).iterator();
            List<?> list = IteratorCache.getList(iterator);
            return new DecomposableJavaContainer(list, list.size());
        }
        if (Iterator.class.isAssignableFrom(actualType)) {
            Iterator iterator = (Iterator)container;
            List<?> list = IteratorCache.getList(iterator);
            return new DecomposableJavaContainer(list, list.size());
        }
        if (Stream.class.isAssignableFrom(actualType)) {
            List<?> javaContainer = StreamCache.getList((Stream)container);
            return new DecomposableJavaContainer(javaContainer, javaContainer.size());
        }
        if (actualType.isArray()) {
            return new DecomposableJavaContainer(container, Array.getLength(container));
        }
        if (Map.class.isAssignableFrom(actualType)) {
            Map map = (Map)container;
            return new DecomposableJavaContainer(container, map.size());
        }
        if (Map.Entry.class.isAssignableFrom(actualType)) {
            return new DecomposableJavaContainer(container, 1);
        }
        if (this.isOptional(actualType)) {
            return new DecomposableJavaContainer(container, 1);
        }
        if (MapEntryElementProperty.MapEntryElementType.class.isAssignableFrom(actualType)) {
            MapEntryElementProperty.MapEntryElementType mapEntryElementType = (MapEntryElementProperty.MapEntryElementType)container;
            return new DecomposableJavaContainer(new AbstractMap.SimpleEntry<Object, Object>(mapEntryElementType.getKey(), mapEntryElementType.getValue()), 1);
        }
        return this.additionalDecomposedContainerValueFactory.from(container);
    }

    private boolean isOptional(Class<?> type) {
        return Optional.class.isAssignableFrom(type) || OptionalInt.class.isAssignableFrom(type) || OptionalLong.class.isAssignableFrom(type) || OptionalDouble.class.isAssignableFrom(type);
    }
}

