/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.context;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.container.ConcurrentLruCache;
import com.navercorp.fixturemonkey.api.context.MonkeyContextBuilder;
import com.navercorp.fixturemonkey.api.context.MonkeyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyPath;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import java.util.Set;
import java.util.TreeMap;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class MonkeyContext {
    private final ConcurrentLruCache<Property, CombinableArbitrary<?>> arbitrariesByProperty;
    private final ConcurrentLruCache<Property, CombinableArbitrary<?>> javaArbitrariesByProperty;
    private final ConcurrentLruCache<RootProperty, MonkeyGeneratorContext> generatorContextByRootProperty;

    public MonkeyContext(ConcurrentLruCache<Property, CombinableArbitrary<?>> arbitrariesByProperty, ConcurrentLruCache<Property, CombinableArbitrary<?>> javaArbitrariesByProperty, ConcurrentLruCache<RootProperty, MonkeyGeneratorContext> generatorContextByRootProperty) {
        this.arbitrariesByProperty = arbitrariesByProperty;
        this.javaArbitrariesByProperty = javaArbitrariesByProperty;
        this.generatorContextByRootProperty = generatorContextByRootProperty;
    }

    public static MonkeyContextBuilder builder() {
        return new MonkeyContextBuilder();
    }

    public CombinableArbitrary<?> getCachedArbitrary(Property property) {
        CombinableArbitrary<?> javaTypeCombinableArbitrary = this.javaArbitrariesByProperty.get(property);
        if (javaTypeCombinableArbitrary != null) {
            return javaTypeCombinableArbitrary;
        }
        return this.arbitrariesByProperty.get(property);
    }

    public void putCachedArbitrary(Property property, CombinableArbitrary<?> combinableArbitrary) {
        Class<?> type = Types.getActualType(property.getType());
        if (Types.isJavaType(type)) {
            this.javaArbitrariesByProperty.putIfAbsent(property, combinableArbitrary);
            return;
        }
        this.arbitrariesByProperty.put(property, combinableArbitrary);
    }

    public MonkeyGeneratorContext retrieveGeneratorContext(RootProperty rootProperty) {
        return this.generatorContextByRootProperty.computeIfAbsent(rootProperty, property -> new MonkeyGeneratorContext(new TreeMap<PropertyPath, Set<Object>>()));
    }
}

