/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArbitraryProperty {
    private final ObjectProperty objectProperty;
    private final boolean container;
    private final double nullInject;
    private final Map<Property, List<Property>> childPropertyListsByCandidateProperty;

    @Deprecated
    public ArbitraryProperty(ObjectProperty objectProperty, boolean container) {
        this.objectProperty = objectProperty;
        this.container = container;
        this.nullInject = objectProperty.getNullInject();
        this.childPropertyListsByCandidateProperty = objectProperty.getChildPropertyListsByCandidateProperty();
    }

    public ArbitraryProperty(ObjectProperty objectProperty, boolean container, double nullInject, Map<Property, List<Property>> childPropertyListsByCandidateProperty) {
        this.objectProperty = objectProperty;
        this.container = container;
        this.nullInject = nullInject;
        this.childPropertyListsByCandidateProperty = childPropertyListsByCandidateProperty;
    }

    public ObjectProperty getObjectProperty() {
        return this.objectProperty;
    }

    public boolean isContainer() {
        return this.container;
    }

    public ArbitraryProperty withNullInject(double nullInject) {
        return new ArbitraryProperty(this.objectProperty.withNullInject(nullInject), this.container);
    }

    public double getNullInject() {
        return this.nullInject;
    }

    public Map<Property, List<Property>> getChildPropertyListsByCandidateProperty() {
        return this.childPropertyListsByCandidateProperty;
    }

    public Map.Entry<Property, List<Property>> getChildPropertiesByResolvedProperty(Matcher matcher) {
        for (Map.Entry<Property, List<Property>> childPropertyListByPossibleProperty : this.childPropertyListsByCandidateProperty.entrySet()) {
            Property property = childPropertyListByPossibleProperty.getKey();
            if (!matcher.match(property)) continue;
            return childPropertyListByPossibleProperty;
        }
        throw new IllegalArgumentException("No resolved property is found.");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArbitraryProperty that = (ArbitraryProperty)obj;
        return this.objectProperty.equals(that.objectProperty) && this.container == that.container;
    }

    public int hashCode() {
        return Objects.hash(this.objectProperty, this.container);
    }
}

