/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.7", status=API.Status.MAINTAINED)
public final class InterfaceObjectPropertyGenerator<T>
implements ObjectPropertyGenerator {
    private final List<Class<? extends T>> implementations;

    public InterfaceObjectPropertyGenerator(List<Class<? extends T>> implementations) {
        this.implementations = implementations;
    }

    @Override
    public ObjectProperty generate(ObjectPropertyGeneratorContext context) {
        HashMap<Property, List<Property>> childPropertiesByProperty = new HashMap<Property, List<Property>>();
        final Property interfaceProperty = context.getProperty();
        double nullInject = context.getNullInjectGenerator().generate(context);
        for (final Class<? extends T> clazz : this.implementations) {
            Property property = new Property(){

                @Override
                public Type getType() {
                    return clazz;
                }

                @Override
                public AnnotatedType getAnnotatedType() {
                    return Types.generateAnnotatedTypeWithoutAnnotation(clazz);
                }

                @Override
                @Nullable
                public String getName() {
                    return interfaceProperty.getName();
                }

                @Override
                public List<Annotation> getAnnotations() {
                    return interfaceProperty.getAnnotations();
                }

                @Override
                @Nullable
                public Object getValue(Object instance) {
                    return interfaceProperty.getValue(instance);
                }
            };
            List<Property> childProperties = context.getPropertyGenerator().generateChildProperties(property);
            childPropertiesByProperty.put(property, childProperties);
        }
        return new ObjectProperty(interfaceProperty, context.getPropertyNameResolver(), nullInject, context.getElementIndex(), childPropertiesByProperty);
    }
}

