/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.matcher.SingleGenericTypeMatcher;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class IteratorIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(IteratorIntrospector.class);
    private static final Matcher MATCHER = new AssignableTypeMatcher(Iterator.class);

    @Override
    public boolean match(Property property) {
        return SingleGenericTypeMatcher.SINGLE_GENERIC_TYPE_MATCHER.match(property) && MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        if (!this.match(context.getResolvedProperty())) {
            LOGGER.info("Given type {} is not Iterator type.", (Object)context.getResolvedType());
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        List<CombinableArbitrary<?>> elementCombinableArbitraryList = context.getElementCombinableArbitraryList();
        CombinableArbitrary<List> combinableArbitrary = CombinableArbitrary.containerBuilder().elements(elementCombinableArbitraryList).build(ArrayList::new);
        return new ArbitraryIntrospectorResult(combinableArbitrary.map(it -> {
            if (it == null) {
                return null;
            }
            return it.iterator();
        }));
    }
}

