/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.FieldProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.type.TypeCache;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.5.3", status=API.Status.MAINTAINED)
public final class FieldPropertyGenerator
implements PropertyGenerator {
    private final Predicate<Field> fieldPredicate;
    private final Matcher matcher;

    public FieldPropertyGenerator(Predicate<Field> fieldPredicate, Matcher matcher) {
        this.fieldPredicate = fieldPredicate;
        this.matcher = matcher;
    }

    @Override
    public List<Property> generateChildProperties(Property property) {
        return TypeCache.getFieldsByName(Types.getActualType(property.getType())).values().stream().filter(this.fieldPredicate).map(field -> new FieldProperty(Types.resolveWithTypeReferenceGenerics(property.getAnnotatedType(), field.getAnnotatedType()), (Field)field)).filter(this.matcher::match).collect(Collectors.toList());
    }
}

