/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.TypeReference;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.6.12", status=API.Status.MAINTAINED)
public abstract class PropertyUtils {
    public static Property toProperty(Class<?> type) {
        return PropertyUtils.toProperty(Types.generateAnnotatedTypeWithoutAnnotation(type));
    }

    public static Property toProperty(final AnnotatedType annotatedType) {
        return new Property(){

            @Override
            public Type getType() {
                return annotatedType.getType();
            }

            @Override
            public AnnotatedType getAnnotatedType() {
                return annotatedType;
            }

            @Override
            @Nullable
            public String getName() {
                return null;
            }

            @Override
            public List<Annotation> getAnnotations() {
                return Arrays.asList(annotatedType.getAnnotations());
            }

            @Override
            @Nullable
            public Object getValue(Object instance) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Property toProperty(final TypeReference<?> typeReference) {
        return new Property(){

            @Override
            public Type getType() {
                return typeReference.getType();
            }

            @Override
            public AnnotatedType getAnnotatedType() {
                return typeReference.getAnnotatedType();
            }

            @Override
            @Nullable
            public String getName() {
                return null;
            }

            @Override
            public List<Annotation> getAnnotations() {
                return Collections.emptyList();
            }

            @Override
            @Nullable
            public Object getValue(Object instance) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean isErasedProperty(Property property) {
        return Types.getActualType(property.getType()) == Object.class || Types.getActualType(property.getAnnotatedType()) == Object.class;
    }
}

