/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.arbitrary;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.arbitrary.ContainerCombinableArbitrary;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.6.0", status=API.Status.MAINTAINED)
public final class ContainerCombineArbitraryBuilder {
    private final List<CombinableArbitrary<?>> elementArbitraryList;
    private Runnable postBuild = () -> {};

    ContainerCombineArbitraryBuilder() {
        this.elementArbitraryList = new ArrayList();
    }

    public ContainerCombineArbitraryBuilder element(CombinableArbitrary<?> arbitrary) {
        this.elementArbitraryList.add(arbitrary);
        return this;
    }

    public ContainerCombineArbitraryBuilder elements(List<CombinableArbitrary<?>> arbitraryList) {
        this.elementArbitraryList.addAll(arbitraryList);
        return this;
    }

    public ContainerCombineArbitraryBuilder postBuild(Runnable postBuilderAction) {
        this.postBuild = postBuilderAction;
        return this;
    }

    public <T> CombinableArbitrary<T> build(Function<List<Object>, T> combinator) {
        return new ContainerCombinableArbitrary<Object>(this.elementArbitraryList, elements -> {
            Object container = combinator.apply((List<Object>)elements);
            this.postBuild.run();
            return container;
        });
    }
}

