/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.CompositePropertyGenerator;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.6.12", status=API.Status.MAINTAINED)
public final class MatchArbitraryIntrospector
implements ArbitraryIntrospector {
    private final List<ArbitraryIntrospector> introspectors;

    public MatchArbitraryIntrospector(List<ArbitraryIntrospector> introspectors) {
        this.introspectors = introspectors;
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        for (ArbitraryIntrospector introspector : this.introspectors) {
            ArbitraryIntrospectorResult result;
            if (!(introspector instanceof Matcher ? ((Matcher)((Object)introspector)).match(context.getResolvedProperty()) && !ArbitraryIntrospectorResult.NOT_INTROSPECTED.equals(result = introspector.introspect(context)) : !ArbitraryIntrospectorResult.NOT_INTROSPECTED.equals(result = introspector.introspect(context)))) continue;
            return result;
        }
        return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
    }

    @Override
    @Nullable
    public PropertyGenerator getRequiredPropertyGenerator(Property property) {
        ArrayList<PropertyGenerator> propertyGenerators = new ArrayList<PropertyGenerator>();
        for (ArbitraryIntrospector introspector : this.introspectors) {
            PropertyGenerator propertyGenerator;
            if (introspector instanceof Matcher && !((Matcher)((Object)introspector)).match(property) || (propertyGenerator = introspector.getRequiredPropertyGenerator(property)) == null) continue;
            propertyGenerators.add(propertyGenerator);
        }
        if (propertyGenerators.isEmpty()) {
            return null;
        }
        return new CompositePropertyGenerator(propertyGenerators);
    }
}

