/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.type;

import com.navercorp.fixturemonkey.api.container.ConcurrentLruCache;
import com.navercorp.fixturemonkey.api.type.Constructors;
import com.navercorp.fixturemonkey.api.type.Reflections;
import com.navercorp.fixturemonkey.api.type.Types;
import java.beans.ConstructorProperties;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.INTERNAL)
public abstract class TypeCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeCache.class);
    private static final Map<Field, AnnotatedType> FIELD_ANNOTATED_TYPE_MAP = new ConcurrentHashMap<Field, AnnotatedType>(2048);
    private static final Map<PropertyDescriptor, AnnotatedType> PROPERTY_DESCRIPTOR_ANNOTATED_TYPE_MAP = new ConcurrentHashMap<PropertyDescriptor, AnnotatedType>(2048);
    private static final Map<Class<?>, Map<String, PropertyDescriptor>> PROPERTY_DESCRIPTORS = new ConcurrentLruCache(2048);
    private static final Map<Class<?>, Map<String, Field>> FIELDS = new ConcurrentLruCache(2048);
    private static final Map<Class<?>, Map.Entry<Constructor<?>, String[]>> PARAMETER_NAMES_BY_PRIMARY_CONSTRUCTOR = new ConcurrentLruCache(2048);
    private static final Map<Class<?>, List<Constructor<?>>> CONSTRUCTORS = new ConcurrentLruCache(2048);

    public static AnnotatedType getAnnotatedType(Field field) {
        return FIELD_ANNOTATED_TYPE_MAP.computeIfAbsent(field, Field::getAnnotatedType);
    }

    public static AnnotatedType getAnnotatedType(PropertyDescriptor propertyDescriptor) {
        return PROPERTY_DESCRIPTOR_ANNOTATED_TYPE_MAP.computeIfAbsent(propertyDescriptor, it -> it.getReadMethod().getAnnotatedReturnType());
    }

    public static Map<String, Field> getFieldsByName(Class<?> clazz) {
        return FIELDS.computeIfAbsent(clazz, type -> {
            ConcurrentHashMap<String, Field> result = new ConcurrentHashMap<String, Field>();
            try {
                List fields = Reflections.findFields(clazz).stream().filter(it -> !Modifier.isStatic(it.getModifiers())).collect(Collectors.toList());
                for (Field field : fields) {
                    field.setAccessible(true);
                    result.put(field.getName(), field);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create fields in type {}.", (Object)clazz.getName());
            }
            return result;
        });
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorsByPropertyName(Class<?> clazz) {
        return PROPERTY_DESCRIPTORS.computeIfAbsent(clazz, type -> {
            ConcurrentHashMap<String, PropertyDescriptor> result = new ConcurrentHashMap<String, PropertyDescriptor>();
            try {
                PropertyDescriptor[] descriptors;
                for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                    if (descriptor.getName().equals("class")) continue;
                    result.put(descriptor.getName(), descriptor);
                }
            }
            catch (IntrospectionException ex) {
                LOGGER.warn("Introspect bean property is failed. type: " + clazz, (Throwable)ex);
            }
            return result;
        });
    }

    public static List<Constructor<?>> getDeclaredConstructors(Class<?> type) {
        return CONSTRUCTORS.computeIfAbsent(type, clazz -> Arrays.asList(clazz.getDeclaredConstructors()));
    }

    public static Constructor<?> getDeclaredConstructor(Class<?> type, Class<?> ... arguments) {
        List<Constructor<?>> constructors = TypeCache.getDeclaredConstructors(type);
        if (constructors.isEmpty()) {
            throw new IllegalArgumentException("The given type " + type + " has no constructor.");
        }
        return constructors.stream().filter(it -> Types.isAssignableTypes(arguments, it.getParameterTypes())).findAny().orElseThrow(() -> new IllegalArgumentException("The given type " + type + " has no matching constructor. parameterTypes: " + Arrays.toString(arguments)));
    }

    @Nullable
    public static Map.Entry<Constructor<?>, String[]> getParameterNamesByConstructor(Class<?> clazz) {
        return PARAMETER_NAMES_BY_PRIMARY_CONSTRUCTOR.computeIfAbsent(clazz, type -> {
            Constructor primaryConstructor;
            ArrayList possibilities = new ArrayList();
            List<Constructor<?>> constructors = TypeCache.getDeclaredConstructors(clazz);
            for (Constructor<?> constructor : constructors) {
                boolean parameterEmpty;
                Parameter[] parameters = constructor.getParameters();
                boolean namePresent = Arrays.stream(parameters).anyMatch(Parameter::isNamePresent);
                boolean bl = parameterEmpty = parameters.length == 0;
                if (namePresent || parameterEmpty) {
                    possibilities.add(constructor);
                    continue;
                }
                ConstructorProperties constructorPropertiesAnnotation = constructor.getAnnotation(ConstructorProperties.class);
                if (constructorPropertiesAnnotation == null) continue;
                possibilities.add(constructor);
            }
            boolean constructorPropertiesPresent = possibilities.stream().anyMatch(it -> it.getAnnotation(ConstructorProperties.class) != null);
            if (constructorPropertiesPresent) {
                primaryConstructor = possibilities.stream().filter(it -> it.getAnnotation(ConstructorProperties.class) != null).findFirst().orElseThrow(() -> new IllegalArgumentException("Constructor should have @ConstructorProperties" + clazz.getSimpleName()));
            } else {
                primaryConstructor = Constructors.findPrimaryConstructor(clazz, possibilities.toArray(new Constructor[0])).orElse(null);
                if (primaryConstructor == null) {
                    return null;
                }
            }
            String[] parameterNames = TypeCache.getParameterNames(primaryConstructor);
            AnnotatedType[] annotatedParameterTypes = primaryConstructor.getAnnotatedParameterTypes();
            if (parameterNames.length != annotatedParameterTypes.length) {
                throw new IllegalArgumentException("@ConstructorProperties values size should same as constructor parameter size");
            }
            return new AbstractMap.SimpleEntry<Constructor, String[]>(primaryConstructor, parameterNames);
        });
    }

    public static void clearCache() {
        FIELD_ANNOTATED_TYPE_MAP.clear();
        PROPERTY_DESCRIPTOR_ANNOTATED_TYPE_MAP.clear();
        PROPERTY_DESCRIPTORS.clear();
        FIELDS.clear();
        PARAMETER_NAMES_BY_PRIMARY_CONSTRUCTOR.clear();
        CONSTRUCTORS.clear();
    }

    private static String[] getParameterNames(Constructor<?> constructor) {
        boolean parameterEmpty;
        Parameter[] parameters = constructor.getParameters();
        boolean namePresent = Arrays.stream(parameters).anyMatch(Parameter::isNamePresent);
        boolean bl = parameterEmpty = parameters.length == 0;
        if (parameterEmpty) {
            return new String[0];
        }
        if (namePresent) {
            return (String[])Arrays.stream(parameters).map(Parameter::getName).toArray(String[]::new);
        }
        boolean anyReceiverParameter = Arrays.stream(constructor.getAnnotatedParameterTypes()).anyMatch(it -> constructor.getAnnotatedReceiverType() != null && it.getType().equals(constructor.getAnnotatedReceiverType().getType()));
        String[] constructorPropertiesNames = constructor.getAnnotation(ConstructorProperties.class).value();
        if (!anyReceiverParameter) {
            return constructorPropertiesNames;
        }
        String receiverParameterName = constructor.getParameters()[0].getName();
        return TypeCache.concatArray(receiverParameterName, constructorPropertiesNames);
    }

    private static String[] concatArray(String single, String[] array) {
        String[] concat = new String[1 + array.length];
        concat[0] = single;
        System.arraycopy(array, 0, concat, 1, array.length);
        return concat;
    }
}

