/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyUtils;
import com.navercorp.fixturemonkey.api.type.Types;
import java.util.HashMap;
import java.util.List;
import org.apiguardian.api.API;

@API(since="1.0.14", status=API.Status.EXPERIMENTAL)
public final class SealedTypeObjectPropertyGenerator
implements ObjectPropertyGenerator {
    @Override
    public ObjectProperty generate(ObjectPropertyGeneratorContext context) {
        Property sealedTypeProperty = context.getProperty();
        Class<?> actualType = Types.getActualType(sealedTypeProperty.getType());
        double nullInject = context.getNullInjectGenerator().generate(context);
        HashMap<Property, List<Property>> childPropertiesByProperty = new HashMap<Property, List<Property>>();
        for (Class<?> subClass : actualType.getPermittedSubclasses()) {
            Property subProperty = PropertyUtils.toProperty(subClass);
            List<Property> subPropertyChildProperties = context.getPropertyGenerator().generateChildProperties(subProperty);
            childPropertiesByProperty.put(subProperty, subPropertyChildProperties);
        }
        return new ObjectProperty(sealedTypeProperty, context.getPropertyNameResolver(), nullInject, context.getElementIndex(), childPropertiesByProperty);
    }
}

