/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.ConcreteTypeDefinition;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArbitraryProperty {
    private final ObjectProperty objectProperty;
    private final boolean container;
    private final double nullInject;
    private final List<ConcreteTypeDefinition> concreteTypeDefinitions;

    @Deprecated
    public ArbitraryProperty(ObjectProperty objectProperty, boolean container) {
        this.objectProperty = objectProperty;
        this.container = container;
        this.nullInject = objectProperty.getNullInject();
        this.concreteTypeDefinitions = ArbitraryProperty.toConcreteTypeDefinition(objectProperty.getChildPropertyListsByCandidateProperty());
    }

    public ArbitraryProperty(ObjectProperty objectProperty, boolean container, double nullInject, Map<Property, List<Property>> childPropertyListsByCandidateProperty) {
        this.objectProperty = objectProperty;
        this.container = container;
        this.nullInject = nullInject;
        this.concreteTypeDefinitions = ArbitraryProperty.toConcreteTypeDefinition(childPropertyListsByCandidateProperty);
    }

    public ObjectProperty getObjectProperty() {
        return this.objectProperty;
    }

    public boolean isContainer() {
        return this.container;
    }

    public ArbitraryProperty withNullInject(double nullInject) {
        return new ArbitraryProperty(this.objectProperty.withNullInject(nullInject), this.container);
    }

    public double getNullInject() {
        return this.nullInject;
    }

    public List<ConcreteTypeDefinition> getConcreteTypeDefinitions() {
        return this.concreteTypeDefinitions;
    }

    @Deprecated
    public Map<Property, List<Property>> getChildPropertyListsByCandidateProperty() {
        return this.concreteTypeDefinitions.stream().collect(Collectors.toMap(ConcreteTypeDefinition::getConcreteProperty, ConcreteTypeDefinition::getChildPropertyLists));
    }

    @Deprecated
    public Map.Entry<Property, List<Property>> getChildPropertiesByResolvedProperty(Matcher matcher) {
        return this.concreteTypeDefinitions.stream().filter(it -> matcher.match(it.getConcreteProperty())).findFirst().map(it -> new AbstractMap.SimpleEntry<Property, List<Property>>(it.getConcreteProperty(), it.getChildPropertyLists())).orElseThrow(() -> new IllegalArgumentException("No resolved property is found."));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArbitraryProperty that = (ArbitraryProperty)obj;
        return this.objectProperty.equals(that.objectProperty) && this.container == that.container;
    }

    public int hashCode() {
        return Objects.hash(this.objectProperty, this.container);
    }

    private static List<ConcreteTypeDefinition> toConcreteTypeDefinition(Map<Property, List<Property>> childPropertyListsByCandidateProperty) {
        return childPropertyListsByCandidateProperty.entrySet().stream().map(entry -> new ConcreteTypeDefinition((Property)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }
}

