/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitraryDelegator;
import com.navercorp.fixturemonkey.api.exception.Exceptions;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.property.DefaultPropertyGenerator;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.type.Reflections;
import com.navercorp.fixturemonkey.api.type.TypeCache;
import com.navercorp.fixturemonkey.api.type.Types;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class BeanArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final BeanArbitraryIntrospector INSTANCE = new BeanArbitraryIntrospector();
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanArbitraryIntrospector.class);

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class<?> type = Types.getActualType(property.getType());
        if (Modifier.isAbstract(type.getModifiers())) {
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        Map<ArbitraryProperty, CombinableArbitrary<?>> arbitrariesByArbitraryProperty = context.getCombinableArbitrariesByArbitraryProperty();
        CombinableArbitrary<Object> generated = context.getGenerated();
        if (generated == CombinableArbitrary.NOT_GENERATED) {
            try {
                this.checkPrerequisite(type);
            }
            catch (Exception ex) {
                LOGGER.warn("Given type {} is failed to generate due to the exception. It may be null.", type, (Object)ex);
                return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
            }
            generated = CombinableArbitrary.from(() -> Reflections.newInstance(type));
        }
        Map<String, PropertyDescriptor> propertyDescriptorsByPropertyName = TypeCache.getPropertyDescriptorsByPropertyName(type);
        return new ArbitraryIntrospectorResult(new CombinableArbitraryDelegator<Object>(CombinableArbitrary.objectBuilder().properties(arbitrariesByArbitraryProperty).build(this.combine(generated::combined, propertyDescriptorsByPropertyName))));
    }

    private void checkPrerequisite(Class<?> type) {
        try {
            TypeCache.getDeclaredConstructor(type, new Class[0]);
        }
        catch (Exception ex) {
            throw Exceptions.throwAsUnchecked(ex);
        }
    }

    private Function<Map<ArbitraryProperty, Object>, Object> combine(Supplier<Object> instance, Map<String, PropertyDescriptor> propertyDescriptorsByPropertyName) {
        return propertyValuesByArbitraryProperty -> {
            Object object = instance.get();
            propertyValuesByArbitraryProperty.forEach((arbitraryProperty, value) -> {
                Property property = arbitraryProperty.getObjectProperty().getProperty();
                String originPropertyName = property.getName();
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyDescriptorsByPropertyName.get(originPropertyName);
                Method writeMethod = propertyDescriptor.getWriteMethod();
                try {
                    if (value != null) {
                        writeMethod.invoke(object, value);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    LOGGER.warn("set bean property is failed. name: {} value: {}", new Object[]{writeMethod.getName(), value, ex});
                }
            });
            return object;
        };
    }

    @Override
    public PropertyGenerator getRequiredPropertyGenerator(Property property) {
        return DefaultPropertyGenerator.FIELD_PROPERTY_GENERATOR;
    }
}

