/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.matcher.Matchers;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.random.Randoms;
import com.navercorp.fixturemonkey.api.type.Types;
import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class EnumIntrospector
implements ArbitraryIntrospector,
Matcher {
    @Override
    public boolean match(Property property) {
        return Matchers.ENUM_TYPE_MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Class<?> type = Types.getActualType(context.getResolvedType());
        if (!type.isEnum()) {
            throw new IllegalArgumentException("Given type is not enum. type: " + type);
        }
        List<?> enums = Arrays.asList(type.getEnumConstants());
        return new ArbitraryIntrospectorResult(CombinableArbitrary.from(() -> enums.get(Randoms.nextInt(enums.size()))));
    }
}

