/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.matcher.SingleGenericTypeMatcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Reflections;
import com.navercorp.fixturemonkey.api.type.TypeCache;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="1.0.16", status=API.Status.EXPERIMENTAL)
public final class SingleGenericCollectionIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleGenericCollectionIntrospector.class);
    private static final Matcher MATCHER = new AssignableTypeMatcher(Collection.class);

    @Override
    public boolean match(Property property) {
        return SingleGenericTypeMatcher.SINGLE_GENERIC_TYPE_MATCHER.match(property) && MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        if (!property.isContainer() || !this.match(context.getResolvedProperty())) {
            LOGGER.info("Given type {} is not List type.", (Object)context.getResolvedType());
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        List<CombinableArbitrary<?>> elementCombinableArbitraryList = context.getElementCombinableArbitraryList();
        Class<?> type = Types.getActualType(context.getResolvedType());
        Constructor<?> declaredConstructor = TypeCache.getDeclaredConstructor(type, Collection.class);
        return new ArbitraryIntrospectorResult(CombinableArbitrary.containerBuilder().elements(elementCombinableArbitraryList).build(list -> Reflections.newInstance(declaredConstructor, list)));
    }
}

