/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.plugin;

import com.navercorp.fixturemonkey.api.generator.InterfaceObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.introspector.AnonymousArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.MatchArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.matcher.ExactTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptionsBuilder;
import com.navercorp.fixturemonkey.api.plugin.Plugin;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;

@API(since="1.0.6", status=API.Status.EXPERIMENTAL)
public final class InterfacePlugin
implements Plugin {
    private final List<MatcherOperator<ObjectPropertyGenerator>> objectPropertyGenerators = new ArrayList<MatcherOperator<ObjectPropertyGenerator>>();
    private boolean useAnonymousArbitraryIntrospector = true;

    public <T> InterfacePlugin interfaceImplements(Class<T> interfaceType, List<Class<? extends T>> implementations) {
        if (!Modifier.isInterface(interfaceType.getModifiers())) {
            throw new IllegalArgumentException("interfaceImplements option first parameter should be interface. " + interfaceType.getTypeName());
        }
        return this.interfaceImplements(new ExactTypeMatcher(interfaceType), implementations);
    }

    public <T> InterfacePlugin interfaceImplements(Matcher matcher, List<Class<? extends T>> implementations) {
        this.objectPropertyGenerators.add(new MatcherOperator<InterfaceObjectPropertyGenerator<? extends T>>(matcher.intersect(p -> Modifier.isInterface(Types.getActualType(p.getType()).getModifiers())), new InterfaceObjectPropertyGenerator<T>(implementations)));
        return this;
    }

    public <T> InterfacePlugin abstractClassExtends(Class<T> abstractClassType, List<Class<? extends T>> implementations) {
        if (!Modifier.isAbstract(abstractClassType.getModifiers())) {
            throw new IllegalArgumentException("abstractClassExtends option first parameter should be abstract class. " + abstractClassType.getTypeName());
        }
        return this.abstractClassExtends(new ExactTypeMatcher(abstractClassType), implementations);
    }

    public <T> InterfacePlugin abstractClassExtends(Matcher matcher, List<Class<? extends T>> implementations) {
        this.objectPropertyGenerators.add(new MatcherOperator<InterfaceObjectPropertyGenerator<? extends T>>(matcher.intersect(p -> Modifier.isAbstract(Types.getActualType(p.getType()).getModifiers())), new InterfaceObjectPropertyGenerator<T>(implementations)));
        return this;
    }

    @Deprecated
    public InterfacePlugin interfaceImplements(MatcherOperator<ObjectPropertyGenerator> objectPropertyGenerator) {
        this.objectPropertyGenerators.add(objectPropertyGenerator);
        return this;
    }

    public InterfacePlugin useAnonymousArbitraryIntrospector(boolean useAnonymousArbitraryIntrospector) {
        this.useAnonymousArbitraryIntrospector = useAnonymousArbitraryIntrospector;
        return this;
    }

    @Override
    public void accept(FixtureMonkeyOptionsBuilder optionsBuilder) {
        for (MatcherOperator<ObjectPropertyGenerator> objectPropertyGenerator : this.objectPropertyGenerators) {
            optionsBuilder.insertFirstArbitraryObjectPropertyGenerator(objectPropertyGenerator);
        }
        if (this.useAnonymousArbitraryIntrospector) {
            optionsBuilder.fallbackIntrospector(it -> new MatchArbitraryIntrospector(Arrays.asList(it, AnonymousArbitraryIntrospector.INSTANCE)));
        }
    }
}

