/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.CandidateConcretePropertyResolver;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyUtils;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="1.0.16", status=API.Status.EXPERIMENTAL)
public final class ConcreteTypeCandidateConcretePropertyResolver<T>
implements CandidateConcretePropertyResolver {
    private final List<Class<? extends T>> concreteTypes;

    public ConcreteTypeCandidateConcretePropertyResolver(List<Class<? extends T>> concreteTypes) {
        this.concreteTypes = concreteTypes;
    }

    @Override
    public List<Property> resolve(final Property property) {
        List<AnnotatedType> genericsTypes = Types.getGenericsTypes(property.getAnnotatedType());
        if (!genericsTypes.isEmpty()) {
            final Type[] typeArguments = (Type[])genericsTypes.stream().map(AnnotatedType::getType).toArray(Type[]::new);
            return this.concreteTypes.stream().map(it -> {
                final ParameterizedType concreteGenericType = new ParameterizedType((Class)it){
                    final /* synthetic */ Class val$it;
                    {
                        this.val$it = clazz;
                    }

                    @Override
                    public Type[] getActualTypeArguments() {
                        return typeArguments;
                    }

                    @Override
                    public Type getRawType() {
                        return this.val$it;
                    }

                    @Override
                    public Type getOwnerType() {
                        return null;
                    }
                };
                final AnnotatedType genericAnnotatedType = new AnnotatedType(){

                    @Override
                    public Type getType() {
                        return concreteGenericType;
                    }

                    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
                        return (A)((Annotation)property.getAnnotation(annotationClass).orElse(null));
                    }

                    @Override
                    public Annotation[] getAnnotations() {
                        return property.getAnnotations().toArray(new Annotation[0]);
                    }

                    @Override
                    public Annotation[] getDeclaredAnnotations() {
                        return property.getAnnotations().toArray(new Annotation[0]);
                    }
                };
                return new Property(){

                    @Override
                    public Type getType() {
                        return genericAnnotatedType.getType();
                    }

                    @Override
                    public AnnotatedType getAnnotatedType() {
                        return genericAnnotatedType;
                    }

                    @Override
                    @Nullable
                    public String getName() {
                        return property.getName();
                    }

                    @Override
                    public List<Annotation> getAnnotations() {
                        return Arrays.asList(genericAnnotatedType.getAnnotations());
                    }

                    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
                        return Optional.ofNullable(genericAnnotatedType.getAnnotation(annotationClass));
                    }

                    @Override
                    @Nullable
                    public Object getValue(Object instance) {
                        return property.getValue(instance);
                    }

                    public int hashCode() {
                        return this.getType().hashCode();
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null || this.getClass() == obj.getClass()) {
                            return false;
                        }
                        Property that = (Property)obj;
                        return this.getType().equals(that.getType());
                    }
                };
            }).collect(Collectors.toList());
        }
        return this.concreteTypes.stream().map(PropertyUtils::toProperty).collect(Collectors.toList());
    }
}

