/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.type;

import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Optional;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class Constructors {
    public static Optional<Constructor<?>> findPrimaryConstructor(Class<?> type, Constructor<?>[] constructors) {
        if (!type.isRecord()) {
            return Arrays.stream(constructors).findFirst();
        }
        Optional<Constructor<?>> primaryConstructor = Arrays.stream(constructors).filter(it -> Constructors.isCanonicalConstructor(type, it)).findFirst();
        if (primaryConstructor.isEmpty()) {
            throw new IllegalArgumentException("Given record has no canonical constructor. type: " + type);
        }
        return primaryConstructor;
    }

    private static boolean isCanonicalConstructor(Class<?> type, Constructor<?> constructor) {
        Class[] recordComponentTypes;
        Class[] parameterTypes = (Class[])Arrays.stream(constructor.getParameters()).map(Parameter::getType).toArray(Class[]::new);
        return Types.isAssignableTypes(parameterTypes, recordComponentTypes = (Class[])Arrays.stream(type.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new)) && Types.isAssignableTypes(recordComponentTypes, parameterTypes);
    }
}

