/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.context;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.container.ConcurrentLruCache;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.context.MonkeyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class MonkeyContextBuilder {
    private ConcurrentLruCache<Property, CombinableArbitrary<?>> arbitrariesByProperty;
    private ConcurrentLruCache<Property, CombinableArbitrary<?>> javaArbitrariesByProperty;
    private ConcurrentLruCache<RootProperty, MonkeyGeneratorContext> generatorContextByRootProperty;
    private int cacheSize = 2048;
    private int generatorContextSize = 1000;

    public MonkeyContextBuilder arbitrariesByProperty(ConcurrentLruCache<Property, CombinableArbitrary<?>> arbitrariesByProperty) {
        this.arbitrariesByProperty = arbitrariesByProperty;
        return this;
    }

    public MonkeyContextBuilder javaArbitrariesByClass(ConcurrentLruCache<Property, CombinableArbitrary<?>> javaArbitrariesByClass) {
        this.javaArbitrariesByProperty = javaArbitrariesByClass;
        return this;
    }

    public MonkeyContextBuilder generatorContextByRootProperty(ConcurrentLruCache<RootProperty, MonkeyGeneratorContext> generatorContextByRootProperty) {
        this.generatorContextByRootProperty = generatorContextByRootProperty;
        return this;
    }

    public MonkeyContextBuilder cacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public MonkeyContextBuilder generatorContextSize(int generatorContextSize) {
        this.generatorContextSize = generatorContextSize;
        return this;
    }

    public MonkeyContext build() {
        if (this.arbitrariesByProperty == null) {
            this.arbitrariesByProperty = new ConcurrentLruCache(this.cacheSize);
        }
        if (this.javaArbitrariesByProperty == null) {
            this.javaArbitrariesByProperty = new ConcurrentLruCache(this.cacheSize);
        }
        if (this.generatorContextByRootProperty == null) {
            this.generatorContextByRootProperty = new ConcurrentLruCache(this.generatorContextSize);
        }
        return new MonkeyContext(this.arbitrariesByProperty, this.javaArbitrariesByProperty, this.generatorContextByRootProperty);
    }
}

