/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ObjectProperty {
    private final Property property;
    private final PropertyNameResolver propertyNameResolver;
    @Deprecated
    private final double nullInject;
    @Nullable
    private final Integer elementIndex;
    @Deprecated
    private final Map<Property, List<Property>> childPropertyListsByCandidateProperty;

    public ObjectProperty(Property property, PropertyNameResolver propertyNameResolver, double nullInject, @Nullable Integer elementIndex, Map<Property, List<Property>> childPropertyListsByCandidateProperty) {
        this.property = property;
        this.propertyNameResolver = propertyNameResolver;
        this.nullInject = nullInject;
        this.elementIndex = elementIndex;
        this.childPropertyListsByCandidateProperty = childPropertyListsByCandidateProperty;
    }

    public Property getProperty() {
        return this.property;
    }

    public PropertyNameResolver getPropertyNameResolver() {
        return this.propertyNameResolver;
    }

    public String getResolvedPropertyName() {
        return this.getPropertyNameResolver().resolve(this.property);
    }

    @Deprecated
    public double getNullInject() {
        return this.nullInject;
    }

    @Nullable
    public Integer getElementIndex() {
        return this.elementIndex;
    }

    @Deprecated
    public Map.Entry<Property, List<Property>> getChildPropertiesByResolvedProperty(Matcher matcher) {
        for (Map.Entry<Property, List<Property>> childPropertyListByPossibleProperty : this.childPropertyListsByCandidateProperty.entrySet()) {
            Property property = childPropertyListByPossibleProperty.getKey();
            if (!matcher.match(property)) continue;
            return childPropertyListByPossibleProperty;
        }
        throw new IllegalArgumentException("No resolved property is found.");
    }

    @Deprecated
    public Map<Property, List<Property>> getChildPropertyListsByCandidateProperty() {
        return this.childPropertyListsByCandidateProperty;
    }

    public boolean isRoot() {
        return this.property instanceof RootProperty;
    }

    @Deprecated
    public ObjectProperty withNullInject(double nullInject) {
        return new ObjectProperty(this.property, this.propertyNameResolver, nullInject, this.elementIndex, this.childPropertyListsByCandidateProperty);
    }

    @Deprecated
    public ObjectProperty withChildPropertyListsByCandidateProperty(Map<Property, List<Property>> childPropertyListsByCandidateProperty) {
        return new ObjectProperty(this.property, this.propertyNameResolver, this.nullInject, this.elementIndex, childPropertyListsByCandidateProperty);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectProperty that = (ObjectProperty)obj;
        return this.property.equals(that.property) && Objects.equals(this.getResolvedPropertyName(), that.getResolvedPropertyName()) && Double.compare(that.nullInject, this.nullInject) == 0 && Objects.equals(this.elementIndex, that.elementIndex) && this.childPropertyListsByCandidateProperty.equals(that.childPropertyListsByCandidateProperty);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.getResolvedPropertyName(), this.nullInject, this.elementIndex, this.childPropertyListsByCandidateProperty);
    }
}

