/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.SingleElementProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class OptionalContainerPropertyGenerator
implements ContainerPropertyGenerator {
    public static final OptionalContainerPropertyGenerator INSTANCE = new OptionalContainerPropertyGenerator();
    private static final AnnotatedType INTEGER_TYPE = Types.generateAnnotatedTypeWithoutAnnotation(Integer.class);
    private static final AnnotatedType LONG_TYPE = Types.generateAnnotatedTypeWithoutAnnotation(Long.class);
    private static final AnnotatedType DOUBLE_TYPE = Types.generateAnnotatedTypeWithoutAnnotation(Double.class);
    private static final ArbitraryContainerInfo CONTAINER_INFO = new ArbitraryContainerInfo(0, 1);

    @Override
    public ContainerProperty generate(ContainerPropertyGeneratorContext context) {
        Property property = context.getProperty();
        final AnnotatedType valueAnnotatedType = this.getOptionalValueAnnotatedType(property);
        final Type valueType = valueAnnotatedType.getType();
        Property childProperty = new Property(){

            @Override
            public Type getType() {
                return valueType;
            }

            @Override
            public AnnotatedType getAnnotatedType() {
                return valueAnnotatedType;
            }

            @Override
            @Nullable
            public String getName() {
                return null;
            }

            @Override
            public List<Annotation> getAnnotations() {
                return Arrays.asList(valueAnnotatedType.getAnnotations());
            }

            @Override
            @Nullable
            public Object getValue(Object instance) {
                Class<?> actualType = Types.getActualType(instance.getClass());
                if (OptionalContainerPropertyGenerator.this.isOptional(actualType)) {
                    return OptionalContainerPropertyGenerator.this.getOptionalValue(instance);
                }
                throw new IllegalArgumentException("given value has no match");
            }
        };
        SingleElementProperty singleElementProperty = new SingleElementProperty(childProperty);
        return new ContainerProperty(Collections.singletonList(singleElementProperty), CONTAINER_INFO);
    }

    private AnnotatedType getOptionalValueAnnotatedType(Property optionalProperty) {
        Class<?> type = Types.getActualType(optionalProperty.getType());
        if (type == OptionalInt.class) {
            return INTEGER_TYPE;
        }
        if (type == OptionalLong.class) {
            return LONG_TYPE;
        }
        if (type == OptionalDouble.class) {
            return DOUBLE_TYPE;
        }
        if (type != Optional.class) {
            throw new IllegalArgumentException("type is not Optional type. propertyType: " + type);
        }
        List<AnnotatedType> genericsTypes = Types.getGenericsTypes(optionalProperty.getAnnotatedType());
        if (genericsTypes.size() != 1) {
            throw new IllegalArgumentException("Optional genericTypes must be have 1 generics type for value. propertyType: " + optionalProperty.getType() + ", genericsTypes: " + genericsTypes);
        }
        return genericsTypes.get(0);
    }

    private boolean isOptional(Class<?> type) {
        return Optional.class.isAssignableFrom(type) || OptionalInt.class.isAssignableFrom(type) || OptionalLong.class.isAssignableFrom(type) || OptionalDouble.class.isAssignableFrom(type);
    }

    private Object getOptionalValue(Object obj) {
        Class<?> actualType = Types.getActualType(obj.getClass());
        if (Optional.class.isAssignableFrom(actualType)) {
            return ((Optional)obj).orElse(null);
        }
        if (OptionalInt.class.isAssignableFrom(actualType)) {
            return ((OptionalInt)obj).orElse(0);
        }
        if (OptionalLong.class.isAssignableFrom(actualType)) {
            return ((OptionalLong)obj).orElse(0L);
        }
        if (OptionalDouble.class.isAssignableFrom(actualType)) {
            return ((OptionalDouble)obj).orElse(Double.NaN);
        }
        throw new IllegalArgumentException("given value is not optional, actual type : " + actualType);
    }
}

