/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.SingleElementProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="1.0.17", status=API.Status.EXPERIMENTAL)
@Deprecated
public final class SupplierContainerPropertyGenerator
implements ContainerPropertyGenerator {
    public static final SupplierContainerPropertyGenerator INSTANCE = new SupplierContainerPropertyGenerator();
    private static final ArbitraryContainerInfo CONTAINER_INFO = new ArbitraryContainerInfo(1, 1);

    @Override
    public ContainerProperty generate(ContainerPropertyGeneratorContext context) {
        Property property = context.getProperty();
        final AnnotatedType valueAnnotatedType = this.getSupplierValueAnnotatedType(property);
        final Type valueType = valueAnnotatedType.getType();
        Property childProperty = new Property(){

            @Override
            public Type getType() {
                return valueType;
            }

            @Override
            public AnnotatedType getAnnotatedType() {
                return valueAnnotatedType;
            }

            @Override
            @Nullable
            public String getName() {
                return null;
            }

            @Override
            public List<Annotation> getAnnotations() {
                return Arrays.asList(valueAnnotatedType.getAnnotations());
            }

            @Override
            public Object getValue(Object instance) {
                Class<?> actualType = Types.getActualType(instance.getClass());
                if (Supplier.class.isAssignableFrom(actualType)) {
                    return instance;
                }
                throw new IllegalArgumentException("given value has no match");
            }
        };
        SingleElementProperty singleElementProperty = new SingleElementProperty(childProperty);
        return new ContainerProperty(Collections.singletonList(singleElementProperty), CONTAINER_INFO);
    }

    private AnnotatedType getSupplierValueAnnotatedType(Property supplierProperty) {
        Class<?> type = Types.getActualType(supplierProperty.getType());
        if (type != Supplier.class) {
            throw new IllegalArgumentException("type is not Supplier type. propertyType: " + type);
        }
        List<AnnotatedType> genericsTypes = Types.getGenericsTypes(supplierProperty.getAnnotatedType());
        if (genericsTypes.size() != 1) {
            throw new IllegalArgumentException("Supplier genericTypes must be have 1 generics type for value. propertyType: " + supplierProperty.getType() + ", genericsTypes: " + genericsTypes);
        }
        return genericsTypes.get(0);
    }
}

