/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.jqwik;

import com.navercorp.fixturemonkey.api.arbitrary.JavaTimeArbitraryGeneratorSet;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class JavaTimeArbitraryIntrospector
implements ArbitraryIntrospector,
Matcher {
    private final Map<Class<?>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>> introspector;

    public JavaTimeArbitraryIntrospector(JavaTimeArbitraryGeneratorSet javaTimeArbitraryGeneratorSet) {
        this.introspector = this.introspectors(javaTimeArbitraryGeneratorSet);
    }

    @Override
    public boolean match(Property property) {
        Class<?> actualType = Types.getActualType(property.getType());
        return this.introspector.containsKey(actualType);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Class<?> type = Types.getActualType(context.getResolvedType());
        return this.introspector.getOrDefault(type, ctx -> ArbitraryIntrospectorResult.NOT_INTROSPECTED).apply(context);
    }

    private Map<Class<?>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>> introspectors(JavaTimeArbitraryGeneratorSet javaTimeArbitraryGeneratorSet) {
        HashMap<Class, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>> introspector = new HashMap<Class, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>>();
        introspector.put(Calendar.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.calendars((ArbitraryGeneratorContext)ctx)));
        introspector.put(Date.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.dates((ArbitraryGeneratorContext)ctx)));
        introspector.put(Instant.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.instants((ArbitraryGeneratorContext)ctx)));
        introspector.put(LocalDate.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.localDates((ArbitraryGeneratorContext)ctx)));
        introspector.put(LocalDateTime.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.localDateTimes((ArbitraryGeneratorContext)ctx)));
        introspector.put(LocalTime.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.localTimes((ArbitraryGeneratorContext)ctx)));
        introspector.put(ZonedDateTime.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.zonedDateTimes((ArbitraryGeneratorContext)ctx)));
        introspector.put(MonthDay.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.monthDays((ArbitraryGeneratorContext)ctx)));
        introspector.put(OffsetDateTime.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.offsetDateTimes((ArbitraryGeneratorContext)ctx)));
        introspector.put(OffsetTime.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.offsetTimes((ArbitraryGeneratorContext)ctx)));
        introspector.put(Period.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.periods((ArbitraryGeneratorContext)ctx)));
        introspector.put(Duration.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.durations((ArbitraryGeneratorContext)ctx)));
        introspector.put(Year.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.years((ArbitraryGeneratorContext)ctx)));
        introspector.put(YearMonth.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.yearMonths((ArbitraryGeneratorContext)ctx)));
        introspector.put(ZoneOffset.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.zoneOffsets((ArbitraryGeneratorContext)ctx)));
        introspector.put(ZoneId.class, ctx -> new ArbitraryIntrospectorResult(javaTimeArbitraryGeneratorSet.zoneIds((ArbitraryGeneratorContext)ctx)));
        return Collections.unmodifiableMap(introspector);
    }
}

