/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.jqwik;

import com.navercorp.fixturemonkey.api.constraint.JavaConstraintGenerator;
import com.navercorp.fixturemonkey.api.constraint.JavaDecimalConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaIntegerConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaStringConstraint;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.jqwik.JavaArbitraryResolver;
import com.navercorp.fixturemonkey.api.random.RegexGenerator;
import com.navercorp.fixturemonkey.api.type.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.BigDecimalArbitrary;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;
import net.jqwik.api.arbitraries.ByteArbitrary;
import net.jqwik.api.arbitraries.DoubleArbitrary;
import net.jqwik.api.arbitraries.FloatArbitrary;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.api.arbitraries.ShortArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.web.api.Web;
import org.apiguardian.api.API;

@API(since="0.6.9", status=API.Status.MAINTAINED)
public final class JqwikJavaArbitraryResolver
implements JavaArbitraryResolver {
    private static final RegexGenerator REGEX_GENERATOR = new RegexGenerator();
    private final JavaConstraintGenerator constraintGenerator;

    public JqwikJavaArbitraryResolver(JavaConstraintGenerator constraintGenerator) {
        this.constraintGenerator = constraintGenerator;
    }

    @Override
    public Arbitrary<String> strings(StringArbitrary stringArbitrary, ArbitraryGeneratorContext context) {
        JavaStringConstraint constraint = this.constraintGenerator.generateStringConstraint(context);
        if (constraint == null) {
            return stringArbitrary;
        }
        BigInteger min = constraint.getMinSize();
        BigInteger max = constraint.getMaxSize();
        boolean digits = constraint.isDigits();
        boolean notBlank = constraint.isNotBlank();
        boolean email = constraint.isEmail();
        JavaStringConstraint.PatternConstraint pattern = constraint.getPattern();
        StringArbitrary arbitrary = stringArbitrary;
        if (pattern != null) {
            int minLength = min == null ? 0 : min.intValue();
            int maxLength = max == null ? Integer.MAX_VALUE : max.intValue();
            Predicate<String> lengthCondition = it -> it.length() >= minLength && it.length() <= maxLength;
            Predicate<String> notBlankCondition = it -> !notBlank || !it.trim().isEmpty();
            return Arbitraries.ofSuppliers((Supplier[])new Supplier[]{() -> REGEX_GENERATOR.generate(pattern.getRegexp(), pattern.getFlags(), lengthCondition.and(notBlankCondition))});
        }
        if (email) {
            arbitrary = Web.emails().allowIpv4Host();
            if (min != null) {
                int emailMinLength = min.intValue();
                arbitrary = arbitrary.filter(it -> it != null && it.length() >= emailMinLength);
            }
            if (max != null) {
                int emailMaxLength = max.intValue();
                arbitrary = arbitrary.filter(it -> it != null && it.length() <= emailMaxLength);
            }
        } else {
            if (min != null) {
                stringArbitrary = stringArbitrary.ofMinLength(min.intValue());
            }
            if (max != null) {
                stringArbitrary = stringArbitrary.ofMaxLength(max.intValue());
            }
            if (digits) {
                stringArbitrary = stringArbitrary.numeric();
            }
            arbitrary = stringArbitrary;
        }
        return arbitrary.filter(it -> {
            if (!notBlank && it == null) {
                return true;
            }
            return it != null && !it.trim().isEmpty();
        });
    }

    @Override
    public Arbitrary<Short> shorts(ShortArbitrary shortArbitrary, ArbitraryGeneratorContext context) {
        JavaIntegerConstraint constraint = this.constraintGenerator.generateIntegerConstraint(context);
        if (constraint == null) {
            return shortArbitrary;
        }
        BigInteger positiveMin = constraint.getPositiveMin();
        BigInteger positiveMax = constraint.getPositiveMax();
        BigInteger negativeMin = constraint.getNegativeMin();
        BigInteger negativeMax = constraint.getNegativeMax();
        ShortArbitrary positiveArbitrary = null;
        ShortArbitrary negativeArbitrary = null;
        if (positiveMin != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> shortArbitrary);
            positiveArbitrary = positiveArbitrary.greaterOrEqual(positiveMin.shortValueExact());
        }
        if (positiveMax != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> shortArbitrary);
            positiveArbitrary = positiveArbitrary.lessOrEqual(positiveMax.shortValueExact());
        }
        if (negativeMin != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> shortArbitrary);
            negativeArbitrary = negativeArbitrary.greaterOrEqual(negativeMin.shortValueExact());
        }
        if (negativeMax != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> shortArbitrary);
            negativeArbitrary = negativeArbitrary.lessOrEqual(negativeMax.shortValueExact());
        }
        return JqwikJavaArbitraryResolver.resolveArbitrary(shortArbitrary, positiveArbitrary, negativeArbitrary);
    }

    @Override
    public Arbitrary<Byte> bytes(ByteArbitrary byteArbitrary, ArbitraryGeneratorContext context) {
        JavaIntegerConstraint constraint = this.constraintGenerator.generateIntegerConstraint(context);
        if (constraint == null) {
            return byteArbitrary;
        }
        BigInteger positiveMin = constraint.getPositiveMin();
        BigInteger positiveMax = constraint.getPositiveMax();
        BigInteger negativeMin = constraint.getNegativeMin();
        BigInteger negativeMax = constraint.getNegativeMax();
        ByteArbitrary positiveArbitrary = null;
        ByteArbitrary negativeArbitrary = null;
        if (positiveMin != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> byteArbitrary);
            positiveArbitrary = positiveArbitrary.greaterOrEqual(positiveMin.byteValueExact());
        }
        if (positiveMax != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> byteArbitrary);
            positiveArbitrary = positiveArbitrary.lessOrEqual(positiveMax.byteValueExact());
        }
        if (negativeMin != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> byteArbitrary);
            negativeArbitrary = negativeArbitrary.greaterOrEqual(negativeMin.byteValueExact());
        }
        if (negativeMax != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> byteArbitrary);
            negativeArbitrary = negativeArbitrary.lessOrEqual(negativeMax.byteValueExact());
        }
        return JqwikJavaArbitraryResolver.resolveArbitrary(byteArbitrary, positiveArbitrary, negativeArbitrary);
    }

    @Override
    public Arbitrary<Float> floats(FloatArbitrary floatArbitrary, ArbitraryGeneratorContext context) {
        JavaDecimalConstraint constraint = this.constraintGenerator.generateDecimalConstraint(context);
        if (constraint == null) {
            return floatArbitrary;
        }
        BigDecimal positiveMin = constraint.getPositiveMin();
        BigDecimal positiveMax = constraint.getPositiveMax();
        Boolean positiveMinInclusive = constraint.getPositiveMinInclusive();
        Boolean positiveMaxInclusive = constraint.getPositiveMaxInclusive();
        BigDecimal negativeMin = constraint.getNegativeMin();
        BigDecimal negativeMax = constraint.getNegativeMax();
        Boolean negativeMinInclusive = constraint.getNegativeMinInclusive();
        Boolean negativeMaxInclusive = constraint.getNegativeMaxInclusive();
        Integer scale = constraint.getScale();
        FloatArbitrary positiveArbitrary = null;
        FloatArbitrary negativeArbitrary = null;
        if (positiveMin != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> floatArbitrary);
            positiveArbitrary = positiveMinInclusive != null && positiveMinInclusive != false ? positiveArbitrary.greaterOrEqual(positiveMin.floatValue()) : positiveArbitrary.greaterThan(positiveMin.floatValue());
        }
        if (positiveMax != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> floatArbitrary);
            positiveArbitrary = positiveMaxInclusive != null && positiveMaxInclusive != false ? positiveArbitrary.lessOrEqual(positiveMax.floatValue()) : positiveArbitrary.lessThan(positiveMax.floatValue());
        }
        if (negativeMin != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> floatArbitrary);
            negativeArbitrary = negativeMinInclusive != null && negativeMinInclusive != false ? negativeArbitrary.greaterOrEqual(negativeMin.floatValue()) : negativeArbitrary.greaterThan(negativeMin.floatValue());
        }
        if (negativeMax != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> floatArbitrary);
            negativeArbitrary = negativeMaxInclusive != null && negativeMaxInclusive != false ? negativeArbitrary.lessOrEqual(negativeMax.floatValue()) : negativeArbitrary.lessThan(negativeMax.floatValue());
        }
        if (scale != null) {
            if (positiveArbitrary != null) {
                positiveArbitrary = positiveArbitrary.ofScale(scale.intValue());
            }
            if (negativeArbitrary != null) {
                negativeArbitrary = negativeArbitrary.ofScale(scale.intValue());
            }
        }
        return JqwikJavaArbitraryResolver.resolveArbitrary(floatArbitrary, positiveArbitrary, negativeArbitrary);
    }

    @Override
    public Arbitrary<Double> doubles(DoubleArbitrary doubleArbitrary, ArbitraryGeneratorContext context) {
        JavaDecimalConstraint constraint = this.constraintGenerator.generateDecimalConstraint(context);
        if (constraint == null) {
            return doubleArbitrary;
        }
        BigDecimal positiveMin = constraint.getPositiveMin();
        BigDecimal positiveMax = constraint.getPositiveMax();
        Boolean positiveMinInclusive = constraint.getPositiveMinInclusive();
        Boolean positiveMaxInclusive = constraint.getPositiveMaxInclusive();
        BigDecimal negativeMin = constraint.getNegativeMin();
        BigDecimal negativeMax = constraint.getNegativeMax();
        Boolean negativeMinInclusive = constraint.getNegativeMinInclusive();
        Boolean negativeMaxInclusive = constraint.getNegativeMaxInclusive();
        Integer scale = constraint.getScale();
        DoubleArbitrary positiveArbitrary = null;
        DoubleArbitrary negativeArbitrary = null;
        if (positiveMin != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> doubleArbitrary);
            positiveArbitrary = positiveMinInclusive != null && positiveMinInclusive != false ? positiveArbitrary.greaterOrEqual(positiveMin.doubleValue()) : positiveArbitrary.greaterThan(positiveMin.doubleValue());
        }
        if (positiveMax != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> doubleArbitrary);
            positiveArbitrary = positiveMaxInclusive != null && positiveMaxInclusive != false ? positiveArbitrary.lessOrEqual(positiveMax.doubleValue()) : positiveArbitrary.lessThan(positiveMax.doubleValue());
        }
        if (negativeMin != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> doubleArbitrary);
            negativeArbitrary = negativeMinInclusive != null && negativeMinInclusive != false ? negativeArbitrary.greaterOrEqual((double)negativeMin.floatValue()) : negativeArbitrary.greaterThan((double)negativeMin.floatValue());
        }
        if (negativeMax != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> doubleArbitrary);
            negativeArbitrary = negativeMaxInclusive != null && negativeMaxInclusive != false ? negativeArbitrary.lessOrEqual(negativeMax.doubleValue()) : negativeArbitrary.lessThan(negativeMax.doubleValue());
        }
        if (scale != null) {
            if (positiveArbitrary != null) {
                positiveArbitrary = positiveArbitrary.ofScale(scale.intValue());
            }
            if (negativeArbitrary != null) {
                negativeArbitrary = negativeArbitrary.ofScale(scale.intValue());
            }
        }
        return JqwikJavaArbitraryResolver.resolveArbitrary(doubleArbitrary, positiveArbitrary, negativeArbitrary);
    }

    @Override
    public Arbitrary<Integer> integers(IntegerArbitrary integerArbitrary, ArbitraryGeneratorContext context) {
        JavaIntegerConstraint constraint = this.constraintGenerator.generateIntegerConstraint(context);
        if (constraint == null) {
            return integerArbitrary;
        }
        BigInteger positiveMin = constraint.getPositiveMin();
        BigInteger positiveMax = constraint.getPositiveMax();
        BigInteger negativeMin = constraint.getNegativeMin();
        BigInteger negativeMax = constraint.getNegativeMax();
        IntegerArbitrary positiveArbitrary = null;
        IntegerArbitrary negativeArbitrary = null;
        if (positiveMin != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> integerArbitrary);
            positiveArbitrary = positiveArbitrary.greaterOrEqual(positiveMin.intValueExact());
        }
        if (positiveMax != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> integerArbitrary);
            positiveArbitrary = positiveArbitrary.lessOrEqual(positiveMax.intValueExact());
        }
        if (negativeMin != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> integerArbitrary);
            negativeArbitrary = negativeArbitrary.greaterOrEqual(negativeMin.intValueExact());
        }
        if (negativeMax != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> integerArbitrary);
            negativeArbitrary = negativeArbitrary.lessOrEqual(negativeMax.intValueExact());
        }
        return JqwikJavaArbitraryResolver.resolveArbitrary(integerArbitrary, positiveArbitrary, negativeArbitrary);
    }

    @Override
    public Arbitrary<Long> longs(LongArbitrary longArbitrary, ArbitraryGeneratorContext context) {
        JavaIntegerConstraint constraint = this.constraintGenerator.generateIntegerConstraint(context);
        if (constraint == null) {
            return longArbitrary;
        }
        BigInteger positiveMin = constraint.getPositiveMin();
        BigInteger positiveMax = constraint.getPositiveMax();
        BigInteger negativeMin = constraint.getNegativeMin();
        BigInteger negativeMax = constraint.getNegativeMax();
        LongArbitrary positiveArbitrary = null;
        LongArbitrary negativeArbitrary = null;
        if (positiveMin != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> longArbitrary);
            positiveArbitrary = positiveArbitrary.greaterOrEqual(positiveMin.longValueExact());
        }
        if (positiveMax != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> longArbitrary);
            positiveArbitrary = positiveArbitrary.lessOrEqual(positiveMax.longValueExact());
        }
        if (negativeMin != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> longArbitrary);
            negativeArbitrary = negativeArbitrary.greaterOrEqual(negativeMin.longValueExact());
        }
        if (negativeMax != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> longArbitrary);
            negativeArbitrary = negativeArbitrary.lessOrEqual(negativeMax.longValueExact());
        }
        return JqwikJavaArbitraryResolver.resolveArbitrary(longArbitrary, positiveArbitrary, negativeArbitrary);
    }

    @Override
    public Arbitrary<BigInteger> bigIntegers(BigIntegerArbitrary bigIntegerArbitrary, ArbitraryGeneratorContext context) {
        JavaIntegerConstraint constraint = this.constraintGenerator.generateIntegerConstraint(context);
        if (constraint == null) {
            return bigIntegerArbitrary;
        }
        BigInteger positiveMin = constraint.getPositiveMin();
        BigInteger positiveMax = constraint.getPositiveMax();
        BigInteger negativeMin = constraint.getNegativeMin();
        BigInteger negativeMax = constraint.getNegativeMax();
        BigIntegerArbitrary positiveArbitrary = null;
        BigIntegerArbitrary negativeArbitrary = null;
        if (positiveMin != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> bigIntegerArbitrary);
            positiveArbitrary = positiveArbitrary.greaterOrEqual(positiveMin);
        }
        if (positiveMax != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> bigIntegerArbitrary);
            positiveArbitrary = positiveArbitrary.lessOrEqual(positiveMax);
        }
        if (negativeMin != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> bigIntegerArbitrary);
            negativeArbitrary = negativeArbitrary.greaterOrEqual(negativeMin);
        }
        if (negativeMax != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> bigIntegerArbitrary);
            negativeArbitrary = negativeArbitrary.lessOrEqual(negativeMax);
        }
        return JqwikJavaArbitraryResolver.resolveArbitrary(bigIntegerArbitrary, positiveArbitrary, negativeArbitrary);
    }

    @Override
    public Arbitrary<BigDecimal> bigDecimals(BigDecimalArbitrary bigDecimalArbitrary, ArbitraryGeneratorContext context) {
        JavaDecimalConstraint constraint = this.constraintGenerator.generateDecimalConstraint(context);
        if (constraint == null) {
            return bigDecimalArbitrary;
        }
        BigDecimal positiveMin = constraint.getPositiveMin();
        BigDecimal positiveMax = constraint.getPositiveMax();
        Boolean positiveMinInclusive = constraint.getPositiveMinInclusive();
        Boolean positiveMaxInclusive = constraint.getPositiveMaxInclusive();
        BigDecimal negativeMin = constraint.getNegativeMin();
        BigDecimal negativeMax = constraint.getNegativeMax();
        Boolean negativeMinInclusive = constraint.getNegativeMinInclusive();
        Boolean negativeMaxInclusive = constraint.getNegativeMaxInclusive();
        Integer scale = constraint.getScale();
        BigDecimalArbitrary positiveArbitrary = null;
        BigDecimalArbitrary negativeArbitrary = null;
        if (positiveMin != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> bigDecimalArbitrary);
            positiveArbitrary = positiveMinInclusive != null && positiveMinInclusive != false ? positiveArbitrary.greaterOrEqual(positiveMin) : positiveArbitrary.greaterThan(positiveMin);
        }
        if (positiveMax != null) {
            positiveArbitrary = Types.defaultIfNull(positiveArbitrary, () -> bigDecimalArbitrary);
            positiveArbitrary = positiveMaxInclusive != null && positiveMaxInclusive != false ? positiveArbitrary.lessOrEqual(positiveMax) : positiveArbitrary.lessThan(positiveMax);
        }
        if (negativeMin != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> bigDecimalArbitrary);
            negativeArbitrary = negativeMinInclusive != null && negativeMinInclusive != false ? negativeArbitrary.greaterOrEqual(negativeMin) : negativeArbitrary.greaterThan(negativeMin);
        }
        if (negativeMax != null) {
            negativeArbitrary = Types.defaultIfNull(negativeArbitrary, () -> bigDecimalArbitrary);
            negativeArbitrary = negativeMaxInclusive != null && negativeMaxInclusive != false ? negativeArbitrary.lessOrEqual(negativeMax) : negativeArbitrary.lessThan(negativeMax);
        }
        if (scale != null) {
            if (positiveArbitrary != null) {
                positiveArbitrary = positiveArbitrary.ofScale(scale.intValue());
            }
            if (negativeArbitrary != null) {
                negativeArbitrary = negativeArbitrary.ofScale(scale.intValue());
            }
        }
        return JqwikJavaArbitraryResolver.resolveArbitrary(bigDecimalArbitrary, positiveArbitrary, negativeArbitrary);
    }

    private static <T> Arbitrary<T> resolveArbitrary(Arbitrary<T> defaultArbitrary, @Nullable Arbitrary<T> positiveArbitrary, @Nullable Arbitrary<T> negativeArbitrary) {
        if (positiveArbitrary != null && negativeArbitrary != null) {
            return Arbitraries.oneOf(positiveArbitrary, (Arbitrary[])new Arbitrary[]{negativeArbitrary});
        }
        if (positiveArbitrary != null) {
            return positiveArbitrary;
        }
        if (negativeArbitrary != null) {
            return negativeArbitrary;
        }
        return defaultArbitrary;
    }
}

