/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="1.0.17", status=API.Status.EXPERIMENTAL)
public final class SingleElementProperty
implements Property {
    private final Property property;
    private final AnnotatedType elementType;
    private final List<Annotation> annotations;
    private final Map<Class<? extends Annotation>, Annotation> annotationsMap;

    public SingleElementProperty(Property property) {
        this.property = property;
        this.elementType = property.getAnnotatedType();
        this.annotations = Arrays.asList(this.elementType.getAnnotations());
        this.annotationsMap = this.annotations.stream().collect(Collectors.toMap(Annotation::annotationType, Function.identity(), (a1, a2) -> a1));
    }

    @Override
    public Type getType() {
        return this.getAnnotatedType().getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.elementType;
    }

    public Property getProperty() {
        return this.property;
    }

    public AnnotatedType getElementType() {
        return this.elementType;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationClass) {
        return Optional.ofNullable(this.annotationsMap.get(annotationClass)).map(annotationClass::cast);
    }

    @Override
    @Nullable
    public Object getValue(Object instance) {
        return this.property.getValue(instance);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SingleElementProperty that = (SingleElementProperty)obj;
        return this.property.equals(that.property) && this.elementType.equals(that.elementType) && this.annotations.equals(that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.elementType, this.annotations);
    }
}

