/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.random;

import com.github.curiousoddman.rgxgen.RgxGen;
import com.github.curiousoddman.rgxgen.config.RgxGenOption;
import com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import com.mifmif.common.regex.Generex;
import dk.brics.automaton.RegExp;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import org.apiguardian.api.API;

@API(since="0.6.9", status=API.Status.MAINTAINED)
public final class RegexGenerator {
    private static final Map<String, String> PREDEFINED_CHARACTER_CLASSES;
    private static final int DEFAULT_REGEXP_GENERATION_TIMEOUT_SEC = 10;
    private static final int FLAG_CASE_INSENSITIVE = 2;
    private static final ExecutorService executor;

    public String generate(String regex, int[] flags, Predicate<String> stringCondition) {
        boolean caseInSensitive = Arrays.stream(flags).anyMatch(it -> it == 2);
        try {
            RgxGen rgxGen = RegexGenerator.generateRgxGen(regex, caseInSensitive);
            String result = executor.submit(() -> rgxGen.stream().filter(stringCondition).findFirst()).get(10L, TimeUnit.SECONDS).orElse(null);
            RegexGenerator.checkValidity(regex, result, caseInSensitive);
            return result;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(String.format("String generation failed for the regular expression \"%s\". Either the regular expression is incorrect, or cannot produce a string that matches the regular expression.", regex));
        }
    }

    @Deprecated
    public List<String> generateAll(String regex, int[] flags, @Nullable Integer min, @Nullable Integer max) {
        RegExp regExp;
        for (Map.Entry<String, String> charClass : PREDEFINED_CHARACTER_CLASSES.entrySet()) {
            regex = regex.replaceAll(charClass.getKey(), charClass.getValue());
        }
        if (flags.length == 0) {
            regExp = new RegExp(regex);
        } else {
            int intFlag = 0;
            for (int flag : flags) {
                intFlag |= flag;
            }
            regExp = new RegExp(regex, intFlag);
        }
        Generex generex = new Generex(regExp.toAutomaton());
        return this.generateAll(generex, min, max);
    }

    @Deprecated
    public List<String> generateAll(String regex) {
        return this.generateAll(regex, null, null);
    }

    @Deprecated
    public List<String> generateAll(String regex, @Nullable Integer min, @Nullable Integer max) {
        return this.generateAll(new Generex(regex), min, max);
    }

    private List<String> generateAll(Generex generex, @Nullable Integer min, @Nullable Integer max) {
        if (min == null) {
            min = 0;
        }
        if (max == null) {
            max = 255;
        }
        Integer regexMin = min;
        Integer regexMax = max;
        List<String> result = generex.getMatchedStrings(100).stream().filter(it -> it.length() >= regexMin && it.length() <= regexMax).collect(Collectors.toList());
        Collections.shuffle(result);
        return result;
    }

    private static RgxGen generateRgxGen(String regex, boolean caseInSensitive) {
        RgxGenProperties properties = new RgxGenProperties();
        if (caseInSensitive) {
            RgxGenOption.CASE_INSENSITIVE.setInProperties(properties, (Object)true);
        }
        RgxGen rgxGen = new RgxGen((CharSequence)regex);
        rgxGen.setProperties(properties);
        return rgxGen;
    }

    private static void checkValidity(String regex, String result, boolean caseInSensitive) {
        Pattern pattern = caseInSensitive ? Pattern.compile(regex, 2) : Pattern.compile(regex);
        if (!pattern.matcher(result).matches()) {
            throw new NoSuchElementException();
        }
    }

    @PreDestroy
    public void terminateExecutor() {
        executor.shutdown();
    }

    static {
        executor = Executors.newSingleThreadExecutor();
        HashMap<String, String> characterClasses = new HashMap<String, String>();
        characterClasses.put("\\\\d", "[0-9]");
        characterClasses.put("\\\\D", "[^0-9]");
        characterClasses.put("\\\\s", "[ \t\n\f\r]");
        characterClasses.put("\\\\S", "[^ \t\n\f\r]");
        characterClasses.put("\\\\w", "[a-zA-Z_0-9]");
        characterClasses.put("\\\\W", "[^a-zA-Z_0-9]");
        PREDEFINED_CHARACTER_CLASSES = Collections.unmodifiableMap(characterClasses);
    }
}

