/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.arbitrary;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.6.0", status=API.Status.MAINTAINED)
final class ContainerCombinableArbitrary<T>
implements CombinableArbitrary<T> {
    private final List<CombinableArbitrary<?>> combinableArbitraryList;
    private final Function<List<Object>, T> combinator;

    ContainerCombinableArbitrary(List<CombinableArbitrary<?>> combinableArbitraryList, Function<List<Object>, T> combinator) {
        this.combinableArbitraryList = combinableArbitraryList;
        this.combinator = combinator;
    }

    @Override
    public T combined() {
        List combinedList = this.combinableArbitraryList.stream().map(CombinableArbitrary::combined).collect(Collectors.toList());
        return this.combinator.apply(combinedList);
    }

    @Override
    public Object rawValue() {
        List rawValues = this.combinableArbitraryList.stream().map(CombinableArbitrary::rawValue).collect(Collectors.toList());
        return this.combinator.apply(rawValues);
    }

    @Override
    public void clear() {
        this.combinableArbitraryList.forEach(arbitrary -> {
            if (!arbitrary.fixed()) {
                arbitrary.clear();
            }
        });
    }

    @Override
    public boolean fixed() {
        if (this.combinableArbitraryList.isEmpty()) {
            return false;
        }
        return this.combinableArbitraryList.stream().allMatch(CombinableArbitrary::fixed);
    }
}

