/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.arbitrary;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.random.Randoms;
import java.lang.reflect.Proxy;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.5.0", status=API.Status.MAINTAINED)
final class NullInjectCombinableArbitrary<T>
implements CombinableArbitrary<T> {
    private final CombinableArbitrary<T> combinableArbitrary;
    private final double nullProbability;

    NullInjectCombinableArbitrary(CombinableArbitrary<T> combinableArbitrary, double nullProbability) {
        this.combinableArbitrary = combinableArbitrary;
        this.nullProbability = nullProbability;
    }

    @Override
    public T combined() {
        T combined = this.combinableArbitrary.combined();
        if (this.nullProbability != 1.0 && combined instanceof Proxy) {
            return combined;
        }
        return (T)this.injectNull(combined);
    }

    @Override
    public Object rawValue() {
        Object rawValue = this.combinableArbitrary.rawValue();
        if (this.nullProbability != 1.0 && rawValue instanceof Proxy) {
            return rawValue;
        }
        return this.injectNull(rawValue);
    }

    @Override
    public void clear() {
        this.combinableArbitrary.clear();
    }

    @Override
    public boolean fixed() {
        return this.combinableArbitrary.fixed();
    }

    @Nullable
    private Object injectNull(Object object) {
        int frequencyNull = (int)Math.round(this.nullProbability * 1000.0);
        if (frequencyNull <= 0) {
            return object;
        }
        int currentSeed = Randoms.nextInt(1000);
        return currentSeed < frequencyNull ? null : object;
    }
}

