/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.6.0", status=API.Status.MAINTAINED)
public final class FailoverIntrospector
implements ArbitraryIntrospector {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailoverIntrospector.class);
    private final List<ArbitraryIntrospector> introspectors;

    public FailoverIntrospector(List<ArbitraryIntrospector> introspectors) {
        this.introspectors = introspectors;
    }

    @Override
    public ArbitraryIntrospectorResult introspect(final ArbitraryGeneratorContext context) {
        final ArrayList<FailoverIntrospectorResult> results = new ArrayList<FailoverIntrospectorResult>();
        for (ArbitraryIntrospector introspector : this.introspectors) {
            try {
                ArbitraryIntrospectorResult result = introspector.introspect(context);
                if (ArbitraryIntrospectorResult.NOT_INTROSPECTED.equals(result)) continue;
                results.add(new FailoverIntrospectorResult(introspector, result));
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("\"%s\" is failed to introspect \"%s\" type.", introspector.getClass().getSimpleName(), ((Class)context.getResolvedProperty().getType()).getName()), (Throwable)ex);
            }
        }
        if (results.isEmpty()) {
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        return new ArbitraryIntrospectorResult(new CombinableArbitrary(){

            public Object combined() {
                Iterator iterator = results.iterator();
                FailoverIntrospectorResult result = null;
                while (iterator.hasNext()) {
                    try {
                        result = (FailoverIntrospectorResult)iterator.next();
                        return result.getResult().getValue().combined();
                    }
                    catch (Exception ex) {
                        LOGGER.warn(String.format("\"%s\" is failed to introspect \"%s\" type.", Objects.requireNonNull(result).getIntrospector().getClass().getSimpleName(), ((Class)context.getResolvedProperty().getType()).getName()), (Throwable)ex);
                    }
                }
                throw new IllegalArgumentException(String.format("Failed to generate type \"%s\"", ((Class)context.getResolvedProperty().getType()).getSimpleName()));
            }

            @Override
            public Object rawValue() {
                Iterator iterator = results.iterator();
                FailoverIntrospectorResult result = null;
                while (iterator.hasNext()) {
                    try {
                        result = (FailoverIntrospectorResult)iterator.next();
                        return result.getResult().getValue().rawValue();
                    }
                    catch (Exception ex) {
                        LOGGER.warn(String.format("\"%s\" is failed to introspect type \"%s\"", Objects.requireNonNull(result).getIntrospector().getClass().getSimpleName(), ((Class)context.getResolvedProperty().getType()).getName()), (Throwable)ex);
                    }
                }
                throw new IllegalArgumentException(String.format("Failed to generate type \"%s\"", ((Class)context.getResolvedProperty().getType()).getSimpleName()));
            }

            @Override
            public void clear() {
                for (FailoverIntrospectorResult result : results) {
                    result.getResult().getValue().clear();
                }
            }

            @Override
            public boolean fixed() {
                return results.stream().allMatch(it -> it.getResult().getValue().fixed());
            }
        });
    }

    private static class FailoverIntrospectorResult {
        private final ArbitraryIntrospector introspector;
        private final ArbitraryIntrospectorResult result;

        public FailoverIntrospectorResult(ArbitraryIntrospector introspector, ArbitraryIntrospectorResult result) {
            this.introspector = introspector;
            this.result = result;
        }

        public ArbitraryIntrospector getIntrospector() {
            return this.introspector;
        }

        public ArbitraryIntrospectorResult getResult() {
            return this.result;
        }
    }
}

