/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.matcher.Matchers;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import java.util.Collections;
import java.util.UUID;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class UuidIntrospector
implements ArbitraryIntrospector,
Matcher {
    @Override
    public boolean match(Property property) {
        return Matchers.UUID_TYPE_MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        if (!this.match(context.getResolvedProperty())) {
            throw new IllegalArgumentException("Given type is not UUID. type: " + context.getResolvedType());
        }
        return new ArbitraryIntrospectorResult(CombinableArbitrary.from(UUID::randomUUID));
    }

    @Override
    public PropertyGenerator getRequiredPropertyGenerator(Property property) {
        return p -> Collections.emptyList();
    }
}

