/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.option;

import com.navercorp.fixturemonkey.api.arbitrary.JavaTimeArbitraryGeneratorSet;
import com.navercorp.fixturemonkey.api.arbitrary.JavaTypeArbitraryGeneratorSet;
import com.navercorp.fixturemonkey.api.constraint.JavaConstraintGenerator;
import com.navercorp.fixturemonkey.api.container.DecomposableJavaContainer;
import com.navercorp.fixturemonkey.api.container.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.api.container.DefaultDecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfoGenerator;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.DefaultNullInjectGenerator;
import com.navercorp.fixturemonkey.api.generator.IntrospectedArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.JavaDefaultArbitraryGeneratorBuilder;
import com.navercorp.fixturemonkey.api.generator.MatchArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.NullInjectGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.instantiator.InstantiatorProcessor;
import com.navercorp.fixturemonkey.api.instantiator.JavaInstantiatorProcessor;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.MatchArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.TypedArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.jqwik.JavaArbitraryResolver;
import com.navercorp.fixturemonkey.api.jqwik.JavaTimeArbitraryResolver;
import com.navercorp.fixturemonkey.api.jqwik.JavaTimeTypeArbitraryGenerator;
import com.navercorp.fixturemonkey.api.jqwik.JavaTypeArbitraryGenerator;
import com.navercorp.fixturemonkey.api.jqwik.JqwikJavaArbitraryResolver;
import com.navercorp.fixturemonkey.api.jqwik.JqwikJavaTimeArbitraryGeneratorSet;
import com.navercorp.fixturemonkey.api.jqwik.JqwikJavaTimeArbitraryResolver;
import com.navercorp.fixturemonkey.api.jqwik.JqwikJavaTypeArbitraryGeneratorSet;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.option.JdkVariantOptions;
import com.navercorp.fixturemonkey.api.plugin.Plugin;
import com.navercorp.fixturemonkey.api.property.CandidateConcretePropertyResolver;
import com.navercorp.fixturemonkey.api.property.DefaultPropertyGenerator;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.api.validator.ArbitraryValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.6.0", status=API.Status.MAINTAINED)
public final class FixtureMonkeyOptionsBuilder {
    private List<MatcherOperator<PropertyGenerator>> propertyGenerators = new ArrayList<MatcherOperator<PropertyGenerator>>(FixtureMonkeyOptions.DEFAULT_PROPERTY_GENERATORS);
    private PropertyGenerator defaultPropertyGenerator = new DefaultPropertyGenerator();
    private List<MatcherOperator<ObjectPropertyGenerator>> arbitraryObjectPropertyGenerators = new ArrayList<MatcherOperator<ObjectPropertyGenerator>>(FixtureMonkeyOptions.DEFAULT_OBJECT_PROPERTY_GENERATORS);
    private List<MatcherOperator<ContainerPropertyGenerator>> containerPropertyGenerators = new ArrayList<MatcherOperator<ContainerPropertyGenerator>>(FixtureMonkeyOptions.DEFAULT_CONTAINER_PROPERTY_GENERATORS);
    private ObjectPropertyGenerator defaultObjectPropertyGenerator;
    private List<MatcherOperator<PropertyNameResolver>> propertyNameResolvers = new ArrayList<MatcherOperator<PropertyNameResolver>>();
    private PropertyNameResolver defaultPropertyNameResolver;
    private List<MatcherOperator<NullInjectGenerator>> nullInjectGenerators = new ArrayList<MatcherOperator<NullInjectGenerator>>(FixtureMonkeyOptions.DEFAULT_NULL_INJECT_GENERATORS);
    private NullInjectGenerator defaultNullInjectGenerator;
    private List<MatcherOperator<ArbitraryContainerInfoGenerator>> arbitraryContainerInfoGenerators = new ArrayList<MatcherOperator<ArbitraryContainerInfoGenerator>>();
    private ArbitraryContainerInfoGenerator defaultArbitraryContainerInfoGenerator;
    private ArbitraryGenerator defaultArbitraryGenerator;
    private UnaryOperator<ArbitraryGenerator> defaultArbitraryGeneratorOperator = it -> it;
    private List<MatcherOperator<ArbitraryIntrospector>> arbitraryIntrospectors = new ArrayList<MatcherOperator<ArbitraryIntrospector>>(FixtureMonkeyOptions.DEFAULT_ARBITRARY_INTROSPECTORS);
    private final JavaDefaultArbitraryGeneratorBuilder javaDefaultArbitraryGeneratorBuilder = IntrospectedArbitraryGenerator.javaBuilder();
    private boolean defaultNotNull = false;
    private boolean nullableContainer = false;
    private boolean nullableElement = false;
    private UnaryOperator<NullInjectGenerator> defaultNullInjectGeneratorOperator = it -> it;
    private ArbitraryValidator defaultArbitraryValidator = obj -> {};
    private DecomposedContainerValueFactory decomposedContainerValueFactory = new DefaultDecomposedContainerValueFactory(obj -> {
        throw new IllegalArgumentException("given type is not supported container : " + obj.getClass().getTypeName());
    });
    private final Map<Class<?>, DecomposedContainerValueFactory> decomposableContainerFactoryMap = new HashMap();
    private int generateMaxTries = 1000;
    private int generateUniqueMaxTries = 1000;
    private JavaConstraintGenerator javaConstraintGenerator = JavaConstraintGenerator.DEFAULT_JAVA_CONSTRAINT_GENERATOR;
    private final List<UnaryOperator<JavaConstraintGenerator>> javaConstraintGeneratorCustomizers = new ArrayList<UnaryOperator<JavaConstraintGenerator>>();
    private JavaTypeArbitraryGenerator javaTypeArbitraryGenerator = new JavaTypeArbitraryGenerator(){};
    @Nullable
    private JavaArbitraryResolver javaArbitraryResolver = null;
    private JavaTimeTypeArbitraryGenerator javaTimeTypeArbitraryGenerator = new JavaTimeTypeArbitraryGenerator(){};
    @Nullable
    private JavaTimeArbitraryResolver javaTimeArbitraryResolver = null;
    @Nullable
    private Function<JavaConstraintGenerator, JavaTypeArbitraryGeneratorSet> generateJavaTypeArbitrarySet = null;
    @Nullable
    private Function<JavaConstraintGenerator, JavaTimeArbitraryGeneratorSet> generateJavaTimeArbitrarySet = null;
    private InstantiatorProcessor instantiatorProcessor = new JavaInstantiatorProcessor();
    private List<MatcherOperator<CandidateConcretePropertyResolver>> candidateConcretePropertyResolvers = new ArrayList<MatcherOperator<CandidateConcretePropertyResolver>>(FixtureMonkeyOptions.DEFAULT_CANDIDATE_CONCRETE_PROPERTY_RESOLVERS);

    FixtureMonkeyOptionsBuilder() {
        new JdkVariantOptions().apply(this);
    }

    public FixtureMonkeyOptionsBuilder propertyGenerators(List<MatcherOperator<PropertyGenerator>> propertyGenerators) {
        this.propertyGenerators = propertyGenerators;
        return this;
    }

    public FixtureMonkeyOptionsBuilder insertFirstPropertyGenerator(MatcherOperator<PropertyGenerator> propertyGenerator) {
        List<MatcherOperator<PropertyGenerator>> result = FixtureMonkeyOptionsBuilder.insertFirst(this.propertyGenerators, propertyGenerator);
        return this.propertyGenerators(result);
    }

    public FixtureMonkeyOptionsBuilder insertFirstPropertyGenerator(Matcher matcher, PropertyGenerator propertyGenerator) {
        return this.insertFirstPropertyGenerator(new MatcherOperator<PropertyGenerator>(matcher, propertyGenerator));
    }

    public FixtureMonkeyOptionsBuilder insertFirstPropertyGenerator(Class<?> type, PropertyGenerator propertyGenerator) {
        return this.insertFirstPropertyGenerator(MatcherOperator.assignableTypeMatchOperator(type, propertyGenerator));
    }

    public FixtureMonkeyOptionsBuilder defaultPropertyGenerator(PropertyGenerator propertyGenerator) {
        this.defaultPropertyGenerator = propertyGenerator;
        return this;
    }

    public FixtureMonkeyOptionsBuilder arbitraryObjectPropertyGenerators(List<MatcherOperator<ObjectPropertyGenerator>> arbitraryObjectPropertyGenerators) {
        this.arbitraryObjectPropertyGenerators = arbitraryObjectPropertyGenerators;
        return this;
    }

    public FixtureMonkeyOptionsBuilder insertFirstArbitraryObjectPropertyGenerator(MatcherOperator<ObjectPropertyGenerator> arbitraryObjectPropertyGenerator) {
        List<MatcherOperator<ObjectPropertyGenerator>> result = FixtureMonkeyOptionsBuilder.insertFirst(this.arbitraryObjectPropertyGenerators, arbitraryObjectPropertyGenerator);
        return this.arbitraryObjectPropertyGenerators(result);
    }

    public FixtureMonkeyOptionsBuilder insertFirstArbitraryObjectPropertyGenerator(Matcher matcher, ObjectPropertyGenerator objectPropertyGenerator) {
        return this.insertFirstArbitraryObjectPropertyGenerator(new MatcherOperator<ObjectPropertyGenerator>(matcher, objectPropertyGenerator));
    }

    public FixtureMonkeyOptionsBuilder insertFirstArbitraryObjectPropertyGenerator(Class<?> type, ObjectPropertyGenerator objectPropertyGenerator) {
        return this.insertFirstArbitraryObjectPropertyGenerator(MatcherOperator.assignableTypeMatchOperator(type, objectPropertyGenerator));
    }

    public FixtureMonkeyOptionsBuilder arbitraryContainerPropertyGenerators(List<MatcherOperator<ContainerPropertyGenerator>> arbitraryContainerPropertyGenerators) {
        this.containerPropertyGenerators = arbitraryContainerPropertyGenerators;
        return this;
    }

    public FixtureMonkeyOptionsBuilder insertFirstArbitraryContainerPropertyGenerator(MatcherOperator<ContainerPropertyGenerator> arbitraryContainerPropertyGenerator) {
        List<MatcherOperator<ContainerPropertyGenerator>> result = FixtureMonkeyOptionsBuilder.insertFirst(this.containerPropertyGenerators, arbitraryContainerPropertyGenerator);
        return this.arbitraryContainerPropertyGenerators(result);
    }

    public FixtureMonkeyOptionsBuilder insertFirstArbitraryContainerPropertyGenerator(Matcher matcher, ContainerPropertyGenerator containerPropertyGenerator) {
        return this.insertFirstArbitraryContainerPropertyGenerator(new MatcherOperator<ContainerPropertyGenerator>(matcher, containerPropertyGenerator));
    }

    public FixtureMonkeyOptionsBuilder insertFirstArbitraryContainerPropertyGenerator(Class<?> type, ContainerPropertyGenerator containerPropertyGenerator) {
        return this.insertFirstArbitraryContainerPropertyGenerator(MatcherOperator.assignableTypeMatchOperator(type, containerPropertyGenerator));
    }

    public FixtureMonkeyOptionsBuilder defaultObjectPropertyGenerator(ObjectPropertyGenerator defaultObjectPropertyGenerator) {
        this.defaultObjectPropertyGenerator = defaultObjectPropertyGenerator;
        return this;
    }

    public FixtureMonkeyOptionsBuilder propertyNameResolvers(List<MatcherOperator<PropertyNameResolver>> propertyNameResolvers) {
        this.propertyNameResolvers = propertyNameResolvers;
        return this;
    }

    public FixtureMonkeyOptionsBuilder insertFirstPropertyNameResolver(MatcherOperator<PropertyNameResolver> propertyNameResolver) {
        List<MatcherOperator<PropertyNameResolver>> result = FixtureMonkeyOptionsBuilder.insertFirst(this.propertyNameResolvers, propertyNameResolver);
        return this.propertyNameResolvers(result);
    }

    public FixtureMonkeyOptionsBuilder insertFirstPropertyNameResolver(Matcher matcher, PropertyNameResolver propertyNameResolver) {
        return this.insertFirstPropertyNameResolver(new MatcherOperator<PropertyNameResolver>(matcher, propertyNameResolver));
    }

    public FixtureMonkeyOptionsBuilder insertFirstPropertyNameResolver(Class<?> type, PropertyNameResolver propertyNameResolver) {
        return this.insertFirstPropertyNameResolver(MatcherOperator.assignableTypeMatchOperator(type, propertyNameResolver));
    }

    public FixtureMonkeyOptionsBuilder defaultPropertyNameResolver(PropertyNameResolver defaultPropertyNameResolver) {
        this.defaultPropertyNameResolver = defaultPropertyNameResolver;
        return this;
    }

    public FixtureMonkeyOptionsBuilder nullInjectGenerators(List<MatcherOperator<NullInjectGenerator>> nullInjectGenerators) {
        this.nullInjectGenerators = nullInjectGenerators;
        return this;
    }

    public FixtureMonkeyOptionsBuilder insertFirstNullInjectGenerators(MatcherOperator<NullInjectGenerator> nullInjectGenerator) {
        List<MatcherOperator<NullInjectGenerator>> result = FixtureMonkeyOptionsBuilder.insertFirst(this.nullInjectGenerators, nullInjectGenerator);
        return this.nullInjectGenerators(result);
    }

    public FixtureMonkeyOptionsBuilder insertFirstNullInjectGenerators(Matcher matcher, NullInjectGenerator nullInjectGenerator) {
        return this.insertFirstNullInjectGenerators(new MatcherOperator<NullInjectGenerator>(matcher, nullInjectGenerator));
    }

    public FixtureMonkeyOptionsBuilder insertFirstNullInjectGenerators(Class<?> type, NullInjectGenerator nullInjectGenerator) {
        return this.insertFirstNullInjectGenerators(MatcherOperator.assignableTypeMatchOperator(type, nullInjectGenerator));
    }

    public FixtureMonkeyOptionsBuilder defaultNullInjectGenerator(NullInjectGenerator defaultNullInjectGenerator) {
        this.defaultNullInjectGenerator = defaultNullInjectGenerator;
        return this;
    }

    public FixtureMonkeyOptionsBuilder defaultNullInjectGeneratorOperator(UnaryOperator<NullInjectGenerator> defaultNullInjectGeneratorOperator) {
        this.defaultNullInjectGeneratorOperator = defaultNullInjectGeneratorOperator;
        return this;
    }

    public FixtureMonkeyOptionsBuilder arbitraryContainerInfoGenerators(List<MatcherOperator<ArbitraryContainerInfoGenerator>> arbitraryContainerInfoGenerators) {
        this.arbitraryContainerInfoGenerators = arbitraryContainerInfoGenerators;
        return this;
    }

    public FixtureMonkeyOptionsBuilder insertFirstArbitraryContainerInfoGenerator(MatcherOperator<ArbitraryContainerInfoGenerator> arbitraryContainerInfoGenerator) {
        List<MatcherOperator<ArbitraryContainerInfoGenerator>> result = FixtureMonkeyOptionsBuilder.insertFirst(this.arbitraryContainerInfoGenerators, arbitraryContainerInfoGenerator);
        return this.arbitraryContainerInfoGenerators(result);
    }

    public FixtureMonkeyOptionsBuilder insertFirstArbitraryContainerInfoGenerator(Matcher matcher, ArbitraryContainerInfoGenerator arbitraryContainerInfoGenerator) {
        return this.insertFirstArbitraryContainerInfoGenerator(new MatcherOperator<ArbitraryContainerInfoGenerator>(matcher, arbitraryContainerInfoGenerator));
    }

    public FixtureMonkeyOptionsBuilder insertFirstArbitraryContainerInfoGenerator(Class<?> type, ArbitraryContainerInfoGenerator arbitraryContainerInfoGenerator) {
        return this.insertFirstArbitraryContainerInfoGenerator(MatcherOperator.assignableTypeMatchOperator(type, arbitraryContainerInfoGenerator));
    }

    public FixtureMonkeyOptionsBuilder defaultArbitraryContainerInfoGenerator(ArbitraryContainerInfoGenerator defaultArbitraryContainerInfoGenerator) {
        this.defaultArbitraryContainerInfoGenerator = defaultArbitraryContainerInfoGenerator;
        return this;
    }

    public FixtureMonkeyOptionsBuilder insertFirstArbitraryIntrospector(MatcherOperator<ArbitraryIntrospector> arbitraryIntrospector) {
        this.arbitraryIntrospectors = FixtureMonkeyOptionsBuilder.insertFirst(this.arbitraryIntrospectors, arbitraryIntrospector);
        return this;
    }

    public FixtureMonkeyOptionsBuilder insertFirstArbitraryIntrospector(Matcher matcher, ArbitraryIntrospector arbitraryIntrospector) {
        return this.insertFirstArbitraryIntrospector(new MatcherOperator<ArbitraryIntrospector>(matcher, arbitraryIntrospector));
    }

    public FixtureMonkeyOptionsBuilder insertFirstArbitraryIntrospector(Class<?> type, ArbitraryIntrospector arbitraryIntrospector) {
        return this.insertFirstArbitraryIntrospector(MatcherOperator.assignableTypeMatchOperator(type, arbitraryIntrospector));
    }

    public FixtureMonkeyOptionsBuilder defaultArbitraryGenerator(UnaryOperator<ArbitraryGenerator> defaultArbitraryGeneratorOperator) {
        this.defaultArbitraryGeneratorOperator = defaultArbitraryGeneratorOperator;
        return this;
    }

    public FixtureMonkeyOptionsBuilder priorityIntrospector(UnaryOperator<ArbitraryIntrospector> priorityIntrospector) {
        this.javaDefaultArbitraryGeneratorBuilder.priorityIntrospector(priorityIntrospector);
        return this;
    }

    public FixtureMonkeyOptionsBuilder containerIntrospector(UnaryOperator<ArbitraryIntrospector> containerIntrospector) {
        this.javaDefaultArbitraryGeneratorBuilder.containerIntrospector(containerIntrospector);
        return this;
    }

    public FixtureMonkeyOptionsBuilder objectIntrospector(UnaryOperator<ArbitraryIntrospector> objectIntrospector) {
        this.javaDefaultArbitraryGeneratorBuilder.objectIntrospector(objectIntrospector);
        return this;
    }

    public FixtureMonkeyOptionsBuilder fallbackIntrospector(UnaryOperator<ArbitraryIntrospector> fallbackIntrospector) {
        this.javaDefaultArbitraryGeneratorBuilder.fallbackIntrospector(fallbackIntrospector);
        return this;
    }

    public FixtureMonkeyOptionsBuilder plugin(Plugin plugin) {
        plugin.accept(this);
        return this;
    }

    public FixtureMonkeyOptionsBuilder defaultNotNull(boolean defaultNotNull) {
        this.defaultNotNull = defaultNotNull;
        return this;
    }

    public FixtureMonkeyOptionsBuilder nullableContainer(boolean nullableContainer) {
        this.nullableContainer = nullableContainer;
        return this;
    }

    public FixtureMonkeyOptionsBuilder nullableElement(boolean nullableElement) {
        this.nullableElement = nullableElement;
        return this;
    }

    public FixtureMonkeyOptionsBuilder defaultArbitraryValidator(ArbitraryValidator arbitraryValidator) {
        this.defaultArbitraryValidator = arbitraryValidator;
        return this;
    }

    public FixtureMonkeyOptionsBuilder decomposedContainerValueFactory(DecomposedContainerValueFactory decomposedContainerValueFactory) {
        this.decomposedContainerValueFactory = decomposedContainerValueFactory;
        return this;
    }

    public FixtureMonkeyOptionsBuilder addDecomposedContainerValueFactory(Class<?> type, DecomposedContainerValueFactory additionalDecomposedContainerValueFactory) {
        this.decomposableContainerFactoryMap.put(type, additionalDecomposedContainerValueFactory);
        return this;
    }

    public FixtureMonkeyOptionsBuilder generateMaxTries(int generateMaxCount) {
        this.generateMaxTries = generateMaxCount;
        return this;
    }

    public FixtureMonkeyOptionsBuilder generateUniqueMaxTries(int generateUniqueMaxTries) {
        this.generateUniqueMaxTries = generateUniqueMaxTries;
        return this;
    }

    public FixtureMonkeyOptionsBuilder javaConstraintGenerator(JavaConstraintGenerator javaConstraintGenerator) {
        this.javaConstraintGenerator = javaConstraintGenerator;
        return this;
    }

    public FixtureMonkeyOptionsBuilder insertFirstJavaConstraintGeneratorCustomizer(UnaryOperator<JavaConstraintGenerator> javaConstraintGeneratorCustomizer) {
        this.javaConstraintGeneratorCustomizers.add(javaConstraintGeneratorCustomizer);
        return this;
    }

    public FixtureMonkeyOptionsBuilder javaTypeArbitraryGeneratorSet(Function<JavaConstraintGenerator, JavaTypeArbitraryGeneratorSet> generateJavaTypeArbitrarySet) {
        this.generateJavaTypeArbitrarySet = generateJavaTypeArbitrarySet;
        return this;
    }

    public FixtureMonkeyOptionsBuilder javaTimeArbitraryGeneratorSet(Function<JavaConstraintGenerator, JavaTimeArbitraryGeneratorSet> generateJavaTimeArbitrarySet) {
        this.generateJavaTimeArbitrarySet = generateJavaTimeArbitrarySet;
        return this;
    }

    public FixtureMonkeyOptionsBuilder instantiatorProcessor(InstantiatorProcessor instantiatorProcessor) {
        this.instantiatorProcessor = instantiatorProcessor;
        return this;
    }

    public FixtureMonkeyOptionsBuilder candidateConcretePropertyResolvers(List<MatcherOperator<CandidateConcretePropertyResolver>> candidateConcretePropertyResolvers) {
        this.candidateConcretePropertyResolvers = candidateConcretePropertyResolvers;
        return this;
    }

    public FixtureMonkeyOptionsBuilder insertFirstCandidateConcretePropertyResolvers(MatcherOperator<CandidateConcretePropertyResolver> candidateConcretePropertyResolver) {
        this.candidateConcretePropertyResolvers = FixtureMonkeyOptionsBuilder.insertFirst(this.candidateConcretePropertyResolvers, candidateConcretePropertyResolver);
        return this;
    }

    public FixtureMonkeyOptions build() {
        ObjectPropertyGenerator defaultObjectPropertyGenerator = FixtureMonkeyOptionsBuilder.defaultIfNull(this.defaultObjectPropertyGenerator, () -> FixtureMonkeyOptions.DEFAULT_OBJECT_PROPERTY_GENERATOR);
        PropertyNameResolver defaultPropertyNameResolver = FixtureMonkeyOptionsBuilder.defaultIfNull(this.defaultPropertyNameResolver, () -> FixtureMonkeyOptions.DEFAULT_PROPERTY_NAME_RESOLVER);
        NullInjectGenerator defaultNullInjectGenerator = FixtureMonkeyOptionsBuilder.defaultIfNull(this.defaultNullInjectGenerator, () -> new DefaultNullInjectGenerator(0.2, this.nullableContainer, this.defaultNotNull, this.nullableElement, new HashSet<String>(DefaultNullInjectGenerator.DEFAULT_NULLABLE_ANNOTATION_TYPES), new HashSet<String>(DefaultNullInjectGenerator.DEFAULT_NOTNULL_ANNOTATION_TYPES)));
        if (this.defaultNullInjectGeneratorOperator != null) {
            defaultNullInjectGenerator = (NullInjectGenerator)this.defaultNullInjectGeneratorOperator.apply(defaultNullInjectGenerator);
        }
        ArbitraryContainerInfoGenerator defaultArbitraryContainerInfoGenerator = FixtureMonkeyOptionsBuilder.defaultIfNull(this.defaultArbitraryContainerInfoGenerator, () -> context -> new ArbitraryContainerInfo(0, 3));
        for (Function function : this.javaConstraintGeneratorCustomizers) {
            this.javaConstraintGenerator = (JavaConstraintGenerator)function.apply(this.javaConstraintGenerator);
        }
        JavaConstraintGenerator resolvedJavaConstraintGenerator = this.javaConstraintGenerator;
        JavaArbitraryResolver javaArbitraryResolver = FixtureMonkeyOptionsBuilder.defaultIfNull(this.javaArbitraryResolver, () -> new JqwikJavaArbitraryResolver(resolvedJavaConstraintGenerator));
        this.generateJavaTypeArbitrarySet = FixtureMonkeyOptionsBuilder.defaultIfNull(this.generateJavaTypeArbitrarySet, () -> constraintGenerator -> new JqwikJavaTypeArbitraryGeneratorSet(this.javaTypeArbitraryGenerator, javaArbitraryResolver));
        this.javaDefaultArbitraryGeneratorBuilder.javaTypeArbitraryGeneratorSet(this.generateJavaTypeArbitrarySet.apply(resolvedJavaConstraintGenerator));
        JavaTimeArbitraryResolver javaTimeArbitraryResolver = FixtureMonkeyOptionsBuilder.defaultIfNull(this.javaTimeArbitraryResolver, () -> new JqwikJavaTimeArbitraryResolver(resolvedJavaConstraintGenerator));
        this.generateJavaTimeArbitrarySet = FixtureMonkeyOptionsBuilder.defaultIfNull(this.generateJavaTimeArbitrarySet, () -> constraintGenerator -> new JqwikJavaTimeArbitraryGeneratorSet(this.javaTimeTypeArbitraryGenerator, javaTimeArbitraryResolver));
        this.javaDefaultArbitraryGeneratorBuilder.javaTimeArbitraryGeneratorSet(this.generateJavaTimeArbitrarySet.apply(resolvedJavaConstraintGenerator));
        ArbitraryGenerator defaultArbitraryGenerator = FixtureMonkeyOptionsBuilder.defaultIfNull(this.defaultArbitraryGenerator, this.javaDefaultArbitraryGeneratorBuilder::build);
        List<ArbitraryIntrospector> typedArbitraryIntrospectors = this.arbitraryIntrospectors.stream().map(TypedArbitraryIntrospector::new).collect(Collectors.toList());
        IntrospectedArbitraryGenerator introspectedGenerator = new IntrospectedArbitraryGenerator(new MatchArbitraryIntrospector(typedArbitraryIntrospectors));
        defaultArbitraryGenerator = new MatchArbitraryGenerator(Arrays.asList(introspectedGenerator, defaultArbitraryGenerator));
        DefaultDecomposedContainerValueFactory decomposedContainerValueFactory = new DefaultDecomposedContainerValueFactory(obj -> {
            Class<?> actualType = obj.getClass();
            for (Map.Entry<Class<?>, DecomposedContainerValueFactory> entry : this.decomposableContainerFactoryMap.entrySet()) {
                DecomposableJavaContainer decomposedValue;
                Class<?> type = entry.getKey();
                try {
                    decomposedValue = entry.getValue().from(obj);
                }
                catch (IllegalArgumentException ex) {
                    continue;
                }
                if (!type.isAssignableFrom(actualType)) continue;
                return decomposedValue;
            }
            return this.decomposedContainerValueFactory.from(obj);
        });
        defaultArbitraryGenerator = (ArbitraryGenerator)this.defaultArbitraryGeneratorOperator.apply(defaultArbitraryGenerator);
        return new FixtureMonkeyOptions(this.propertyGenerators, this.defaultPropertyGenerator, this.arbitraryObjectPropertyGenerators, defaultObjectPropertyGenerator, this.containerPropertyGenerators, this.propertyNameResolvers, defaultPropertyNameResolver, this.nullInjectGenerators, defaultNullInjectGenerator, this.arbitraryContainerInfoGenerators, defaultArbitraryContainerInfoGenerator, defaultArbitraryGenerator, this.defaultArbitraryValidator, decomposedContainerValueFactory, this.generateMaxTries, this.generateUniqueMaxTries, resolvedJavaConstraintGenerator, this.instantiatorProcessor, this.candidateConcretePropertyResolvers);
    }

    private static <T> T defaultIfNull(@Nullable T obj, Supplier<T> defaultValue) {
        return obj != null ? obj : defaultValue.get();
    }

    private static <T> List<T> insertFirst(List<T> list, T value) {
        ArrayList<T> result = new ArrayList<T>();
        result.add(value);
        result.addAll(list);
        return result;
    }
}

