/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.type;

import java.lang.annotation.Annotation;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="1.0.0", status=API.Status.INTERNAL)
public abstract class KotlinTypeDetector {
    @Nullable
    private static final Class<? extends Annotation> kotlinMetadata;

    public static boolean isKotlinType(Class<?> clazz) {
        return kotlinMetadata != null && clazz.getDeclaredAnnotation(kotlinMetadata) != null;
    }

    static {
        Class<?> metadata;
        ClassLoader classLoader = KotlinTypeDetector.class.getClassLoader();
        try {
            metadata = Class.forName("kotlin.Metadata", false, classLoader);
        }
        catch (ClassNotFoundException ex) {
            metadata = null;
        }
        kotlinMetadata = metadata;
    }
}

