/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import java.lang.reflect.InvocationHandler;
import java.util.Map;
import org.apiguardian.api.API;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@API(since="0.6.10", status=API.Status.MAINTAINED)
final class InvocationHandlerBuilder {
    private final Map<String, Object> generatedValuesByMethodName;

    InvocationHandlerBuilder(Map<String, Object> generatedValuesByMethodName) {
        this.generatedValuesByMethodName = generatedValuesByMethodName;
    }

    void put(String methodName, Object value) {
        this.generatedValuesByMethodName.put(methodName, value);
    }

    InvocationHandler build() {
        return (proxy, method, args) -> {
            if (method.isDefault()) {
                return InvocationHandler.invokeDefault(proxy, method, args);
            }
            return this.generatedValuesByMethodName.get(method.getName());
        };
    }

    boolean isEmpty() {
        return this.generatedValuesByMethodName.isEmpty();
    }
}

