/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.experimental;

import com.navercorp.fixturemonkey.api.experimental.JavaGetterMethodPropertySelector;
import com.navercorp.fixturemonkey.api.experimental.JavaGetterMethodReference;
import com.navercorp.fixturemonkey.api.property.CompositeProperty;
import com.navercorp.fixturemonkey.api.property.FieldProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyDescriptorProperty;
import com.navercorp.fixturemonkey.api.type.KotlinTypeDetector;
import com.navercorp.fixturemonkey.api.type.TypeCache;
import java.beans.PropertyDescriptor;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nullable;

abstract class JavaGetterPropertySelectors {
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";

    JavaGetterPropertySelectors() {
    }

    static <T, R> JavaGetterMethodPropertySelector<T, R> resolvePropertySelector(JavaGetterMethodReference<T, R> methodRef) {
        try {
            Property resolvedProperty;
            Class<?> methodRefClass = methodRef.getClass();
            Method replaceMethod = methodRefClass.getDeclaredMethod("writeReplace", new Class[0]);
            replaceMethod.setAccessible(true);
            SerializedLambda lambda = (SerializedLambda)replaceMethod.invoke(methodRef, new Object[0]);
            String className = lambda.getImplClass().replace('/', '.');
            ClassLoader classLoader = methodRefClass.getClassLoader() != null ? methodRefClass.getClassLoader() : JavaGetterPropertySelectors.class.getClassLoader();
            Class<?> targetClass = Class.forName(className, true, classLoader);
            if (KotlinTypeDetector.isKotlinType(targetClass)) {
                throw new IllegalArgumentException("Kotlin type could not resolve property name. type: " + targetClass);
            }
            String fieldName = JavaGetterPropertySelectors.resolveFieldName(targetClass, lambda.getImplMethodName());
            Property fieldProperty = JavaGetterPropertySelectors.resolveFieldProperty(targetClass, fieldName);
            Property propertyDescriptorProperty = JavaGetterPropertySelectors.resolvePropertyDescriptorProperty(targetClass, fieldName);
            if (fieldProperty != null && propertyDescriptorProperty != null) {
                resolvedProperty = new CompositeProperty(fieldProperty, propertyDescriptorProperty);
            } else if (fieldProperty != null) {
                resolvedProperty = fieldProperty;
            } else if (propertyDescriptorProperty != null) {
                resolvedProperty = propertyDescriptorProperty;
            } else {
                throw new IllegalArgumentException("Could not resolve a field or a JavaBeans getter by given lambda. type: " + targetClass);
            }
            return new JavaGetterMethodPropertySelector(targetClass, resolvedProperty);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not resolve a field or a JavaBeans getter by given lambda. lambda: " + methodRef, ex);
        }
    }

    @Nullable
    private static String resolveFieldName(Class<?> targetClass, String methodName) {
        if (JavaGetterPropertySelectors.hasPrefix(GET_PREFIX, methodName)) {
            return JavaGetterPropertySelectors.stripPrefixPropertyName(targetClass, methodName, GET_PREFIX.length());
        }
        if (JavaGetterPropertySelectors.hasPrefix(IS_PREFIX, methodName)) {
            return JavaGetterPropertySelectors.stripPrefixPropertyName(targetClass, methodName, IS_PREFIX.length());
        }
        if (JavaGetterPropertySelectors.isValidField(targetClass, methodName)) {
            return methodName;
        }
        return null;
    }

    @Nullable
    private static Property resolveFieldProperty(Class<?> targetClass, String fieldName) {
        Map<String, Field> fieldsByName = TypeCache.getFieldsByName(targetClass);
        if (!fieldsByName.containsKey(fieldName)) {
            return null;
        }
        return new FieldProperty(fieldsByName.get(fieldName));
    }

    @Nullable
    private static Property resolvePropertyDescriptorProperty(Class<?> targetClass, String fieldName) {
        Map<String, PropertyDescriptor> propertyDescriptorsByPropertyName = TypeCache.getPropertyDescriptorsByPropertyName(targetClass);
        if (!propertyDescriptorsByPropertyName.containsKey(fieldName)) {
            return null;
        }
        return new PropertyDescriptorProperty(propertyDescriptorsByPropertyName.get(fieldName));
    }

    private static String stripPrefixPropertyName(Class<?> targetClass, String methodName, int prefixLength) {
        char[] ch = methodName.toCharArray();
        ch[prefixLength] = Character.toLowerCase(ch[prefixLength]);
        String fieldName = new String(ch, prefixLength, ch.length - prefixLength);
        return JavaGetterPropertySelectors.isValidField(targetClass, fieldName) ? fieldName : null;
    }

    private static boolean hasPrefix(String prefix, String methodName) {
        return methodName.startsWith(prefix) && methodName.length() > prefix.length();
    }

    private static boolean isValidField(Class<?> type, String fieldName) {
        return TypeCache.getFieldsByName(type).containsKey(fieldName);
    }
}

