/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.ElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArrayContainerPropertyGenerator
implements ContainerPropertyGenerator {
    public static final ArrayContainerPropertyGenerator INSTANCE = new ArrayContainerPropertyGenerator();

    @Override
    public ContainerProperty generate(ContainerPropertyGeneratorContext context) {
        Property property = context.getProperty();
        ArbitraryContainerInfo containerInfo = context.getContainerInfo();
        int size = containerInfo.getRandomSize();
        AnnotatedType elementType = Types.getArrayComponentAnnotatedType(property.getAnnotatedType());
        ArrayList<Property> childProperties = new ArrayList<Property>();
        for (int sequence = 0; sequence < size; ++sequence) {
            childProperties.add(new ElementProperty(property, elementType, sequence, sequence));
        }
        return new ContainerProperty(childProperties, containerInfo);
    }
}

