/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.arbitrary.TraceableCombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.JavaDefaultArbitraryGeneratorBuilder;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.6.2", status=API.Status.MAINTAINED)
public final class IntrospectedArbitraryGenerator
implements ArbitraryGenerator {
    private final ArbitraryIntrospector arbitraryIntrospector;

    public IntrospectedArbitraryGenerator(ArbitraryIntrospector arbitraryIntrospector) {
        this.arbitraryIntrospector = arbitraryIntrospector;
    }

    public static JavaDefaultArbitraryGeneratorBuilder javaBuilder() {
        return new JavaDefaultArbitraryGeneratorBuilder();
    }

    @Override
    public CombinableArbitrary<?> generate(ArbitraryGeneratorContext context) {
        if (context.getGenerated() != CombinableArbitrary.NOT_GENERATED) {
            return context.getGenerated();
        }
        ArbitraryIntrospectorResult result = this.arbitraryIntrospector.introspect(context);
        if (result != ArbitraryIntrospectorResult.NOT_INTROSPECTED && result.getValue() != null) {
            double nullInject = context.getArbitraryProperty().getNullInject();
            return new TraceableCombinableArbitrary(result.getValue().injectNull(nullInject), context.getPropertyPath());
        }
        return CombinableArbitrary.NOT_GENERATED;
    }

    @Override
    @Nullable
    public PropertyGenerator getRequiredPropertyGenerator(Property property) {
        return this.arbitraryIntrospector.getRequiredPropertyGenerator(property);
    }
}

