/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Objects;
import org.apiguardian.api.API;

@API(since="1.0.21", status=API.Status.EXPERIMENTAL)
public final class FunctionalInterfaceArbitraryIntrospector
implements ArbitraryIntrospector {
    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        if (!property.isContainer()) {
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        List<CombinableArbitrary<?>> elementCombinableArbitraryList = context.getElementCombinableArbitraryList();
        int lastElementIndex = elementCombinableArbitraryList.size() - 1;
        CombinableArbitrary<Object> result = elementCombinableArbitraryList.get(lastElementIndex).map(it -> this.toFunctionalInterface(Types.getActualType(context.getResolvedType()), it));
        return new ArbitraryIntrospectorResult(result);
    }

    private <T> Object toFunctionalInterface(Class<?> type, T value) {
        return Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (proxy, method, args) -> {
            if (method != null && "equals".equals(method.getName())) {
                return Objects.equals(args[0], value);
            }
            return value;
        });
    }
}

