/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.jqwik;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.Year;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import net.jqwik.api.Arbitrary;
import net.jqwik.time.api.DateTimes;
import net.jqwik.time.api.Dates;
import net.jqwik.time.api.Times;
import net.jqwik.time.api.arbitraries.CalendarArbitrary;
import net.jqwik.time.api.arbitraries.DateArbitrary;
import net.jqwik.time.api.arbitraries.DurationArbitrary;
import net.jqwik.time.api.arbitraries.InstantArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.LocalTimeArbitrary;
import net.jqwik.time.api.arbitraries.MonthDayArbitrary;
import net.jqwik.time.api.arbitraries.OffsetDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetTimeArbitrary;
import net.jqwik.time.api.arbitraries.PeriodArbitrary;
import net.jqwik.time.api.arbitraries.YearArbitrary;
import net.jqwik.time.api.arbitraries.YearMonthArbitrary;
import net.jqwik.time.api.arbitraries.ZoneOffsetArbitrary;
import net.jqwik.time.api.arbitraries.ZonedDateTimeArbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public interface JavaTimeTypeArbitraryGenerator {
    default public CalendarArbitrary calendars() {
        Instant now = Instant.now();
        Calendar min = Calendar.getInstance();
        min.setTimeInMillis(now.minus(365L, ChronoUnit.DAYS).toEpochMilli());
        Calendar max = Calendar.getInstance();
        max.setTimeInMillis(now.plus(365L, ChronoUnit.DAYS).toEpochMilli());
        return Dates.datesAsCalendar().between(min, max);
    }

    default public DateArbitrary dates() {
        Instant now = Instant.now();
        Date min = new Date(now.minus(365L, ChronoUnit.DAYS).toEpochMilli());
        Date max = new Date(now.plus(365L, ChronoUnit.DAYS).toEpochMilli());
        return Dates.datesAsDate().between(min, max);
    }

    default public InstantArbitrary instants() {
        Instant now = Instant.now();
        return DateTimes.instants().between(now.minus(365L, ChronoUnit.DAYS), now.plus(365L, ChronoUnit.DAYS));
    }

    default public LocalDateArbitrary localDates() {
        LocalDate now = LocalDate.now();
        return Dates.dates().between(now.minusDays(365L), now.plusDays(365L));
    }

    default public LocalDateTimeArbitrary localDateTimes() {
        LocalDateTime now = LocalDateTime.now();
        return DateTimes.dateTimes().between(now.minusDays(365L), now.plusDays(365L));
    }

    default public LocalTimeArbitrary localTimes() {
        return Times.times();
    }

    default public ZonedDateTimeArbitrary zonedDateTimes() {
        LocalDateTime now = LocalDateTime.now();
        return DateTimes.zonedDateTimes().between(now.minusDays(365L), now.plusDays(365L));
    }

    default public MonthDayArbitrary monthDays() {
        return Dates.monthDays();
    }

    default public OffsetDateTimeArbitrary offsetDateTimes() {
        LocalDateTime now = LocalDateTime.now();
        return DateTimes.offsetDateTimes().between(now.minusDays(365L), now.plusDays(365L));
    }

    default public OffsetTimeArbitrary offsetTimes() {
        return Times.offsetTimes();
    }

    default public PeriodArbitrary periods() {
        return Dates.periods().between(Period.ofDays(-365), Period.ofDays(365));
    }

    default public DurationArbitrary durations() {
        return Times.durations().between(Duration.ofDays(-365L), Duration.ofDays(365L));
    }

    default public YearArbitrary years() {
        return Dates.years().between(Year.now().minusYears(10L), Year.now().plusYears(10L));
    }

    default public YearMonthArbitrary yearMonths() {
        return Dates.yearMonths().yearBetween(Year.now().minusYears(10L), Year.now().plusYears(10L));
    }

    default public ZoneOffsetArbitrary zoneOffsets() {
        return Times.zoneOffsets();
    }

    default public Arbitrary<ZoneId> zoneId() {
        return Times.zoneIds();
    }
}

