/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.ConstantProperty;
import com.navercorp.fixturemonkey.api.property.FieldProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.type.TypeCache;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.5.3", status=API.Status.MAINTAINED)
public final class FieldPropertyGenerator
implements PropertyGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldPropertyGenerator.class);
    private static final Predicate<Field> CONSTANT_FIELD_PREDICATE = f -> Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers());
    private final Predicate<Field> fieldPredicate;
    private final Matcher matcher;

    public FieldPropertyGenerator(Predicate<Field> fieldPredicate, Matcher matcher) {
        this.fieldPredicate = fieldPredicate;
        this.matcher = matcher;
    }

    @Override
    public List<Property> generateChildProperties(Property property) {
        Stream<FieldProperty> arbitraryfieldStream = TypeCache.getFieldsByName(Types.getActualType(property.getType())).values().stream().filter(this.fieldPredicate.and(CONSTANT_FIELD_PREDICATE.negate())).map(field -> new FieldProperty(Types.resolveWithTypeReferenceGenerics(property.getAnnotatedType(), field.getAnnotatedType()), (Field)field)).filter(this.matcher::match);
        Stream<Property> constantPropertyStream = TypeCache.getFieldsByName(Types.getActualType(property.getType())).values().stream().filter(CONSTANT_FIELD_PREDICATE).map(field -> {
            Object constantValue = null;
            try {
                constantValue = field.get(null);
            }
            catch (IllegalAccessException ex) {
                LOGGER.warn("Field {} is inaccessible.", (Object)field.getName(), (Object)ex);
            }
            return new ConstantProperty(Types.resolveWithTypeReferenceGenerics(property.getAnnotatedType(), field.getAnnotatedType()), field.getName(), constantValue, Arrays.asList(field.getAnnotations()));
        });
        return Stream.concat(arbitraryfieldStream, constantPropertyStream).collect(Collectors.toList());
    }
}

