/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@API(since="0.6.10", status=API.Status.MAINTAINED)
final class InvocationHandlerBuilder {
    private static final String HASH_CODE_METHOD = "hashCode";
    private static final String EQUALS_METHOD = "equals";
    private static final String TO_STRING_METHOD = "toString";
    private static final String INVOKE_METHOD = "invoke";
    private final Class<?> type;
    private final Map<String, Object> generatedValuesByMethodName;

    InvocationHandlerBuilder(Class<?> type, Map<String, Object> generatedValuesByMethodName) {
        this.type = type;
        this.generatedValuesByMethodName = generatedValuesByMethodName;
    }

    void put(String methodName, Object value) {
        this.generatedValuesByMethodName.put(methodName, value);
    }

    InvocationHandler build() {
        return (proxy, method, args) -> {
            if (method == null) {
                return this.generatedValuesByMethodName.get(INVOKE_METHOD);
            }
            if (method.isDefault()) {
                return InvocationHandler.invokeDefault(proxy, method, args);
            }
            if (HASH_CODE_METHOD.equals(method.getName()) && args == null) {
                return this.generatedValuesByMethodName.values().hashCode();
            }
            if (EQUALS_METHOD.equals(method.getName()) && args.length == 1) {
                Object other = args[0];
                return this.compareAllReturnValues(other);
            }
            if (TO_STRING_METHOD.equals(method.getName()) && args == null) {
                return this.toString(proxy);
            }
            return this.generatedValuesByMethodName.get(method.getName());
        };
    }

    boolean isEmpty() {
        return this.generatedValuesByMethodName.isEmpty();
    }

    private boolean compareAllReturnValues(Object other) {
        if (other == null) {
            return false;
        }
        if (!this.type.isInstance(other)) {
            return false;
        }
        for (Map.Entry<String, Object> methodNameToValue : this.generatedValuesByMethodName.entrySet()) {
            String methodName = methodNameToValue.getKey();
            Object returnValue = methodNameToValue.getValue();
            try {
                Method otherMethod = other.getClass().getMethod(methodName, new Class[0]);
                Object otherValue = otherMethod.invoke(other, new Object[0]);
                if (returnValue.equals(otherValue)) continue;
                return false;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unexpected error in invoking method " + methodName, e);
            }
        }
        return true;
    }

    private String toString(Object proxy) {
        String joined = this.generatedValuesByMethodName.entrySet().stream().map(e -> (String)e.getKey() + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(", "));
        return proxy.getClass().getName() + "{" + joined + "}";
    }
}

