/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitraryDelegator;
import com.navercorp.fixturemonkey.api.exception.Exceptions;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorLoggingContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.property.DefaultPropertyGenerator;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.type.Reflections;
import com.navercorp.fixturemonkey.api.type.TypeCache;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class FieldReflectionArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final FieldReflectionArbitraryIntrospector INSTANCE = new FieldReflectionArbitraryIntrospector();
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldReflectionArbitraryIntrospector.class);

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class<?> type = Types.getActualType(property.getType());
        if (Modifier.isAbstract(type.getModifiers())) {
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        Map<ArbitraryProperty, CombinableArbitrary<?>> arbitrariesByArbitraryProperty = context.getCombinableArbitrariesByArbitraryProperty();
        CombinableArbitrary<Object> generated = context.getGenerated();
        if (generated == CombinableArbitrary.NOT_GENERATED) {
            try {
                this.checkPrerequisite(type);
            }
            catch (Exception ex) {
                ArbitraryGeneratorLoggingContext loggingContext = context.getLoggingContext();
                if (loggingContext.isEnableLoggingFail()) {
                    LOGGER.warn("Given type {} is failed to generate due to the exception. It may be null.", type, (Object)ex);
                }
                return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
            }
            generated = CombinableArbitrary.from(() -> Reflections.newInstance(type));
        }
        Map<String, Field> fieldsByPropertyName = TypeCache.getFieldsByName(type);
        return new ArbitraryIntrospectorResult(new CombinableArbitraryDelegator<Object>(CombinableArbitrary.objectBuilder().properties(arbitrariesByArbitraryProperty).build(this.combine(generated::combined, fieldsByPropertyName))));
    }

    private void checkPrerequisite(Class<?> type) {
        try {
            TypeCache.getDeclaredConstructor(type, new Class[0]);
        }
        catch (Exception ex) {
            throw Exceptions.throwAsUnchecked(ex);
        }
    }

    private Function<Map<ArbitraryProperty, Object>, Object> combine(Supplier<Object> instance, Map<String, Field> fieldsByPropertyName) {
        return propertyValuesByArbitraryProperty -> {
            Object object = instance.get();
            propertyValuesByArbitraryProperty.forEach((arbitraryProperty, value) -> {
                Property property = arbitraryProperty.getObjectProperty().getProperty();
                String originPropertyName = property.getName();
                Field field = (Field)fieldsByPropertyName.get(originPropertyName);
                if (field == null || Modifier.isFinal(field.getModifiers()) && Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) {
                    return;
                }
                String resolvePropertyName = arbitraryProperty.getObjectProperty().getResolvedPropertyName();
                try {
                    if (value != null) {
                        field.set(object, value);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    LOGGER.warn("set field by reflection is failed. field: {} value: {}", new Object[]{resolvePropertyName, value, ex});
                }
            });
            return object;
        };
    }

    @Override
    public PropertyGenerator getRequiredPropertyGenerator(Property property) {
        return DefaultPropertyGenerator.FIELD_PROPERTY_GENERATOR;
    }
}

