/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.introspector.InvocationHandlerBuilder;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;

@API(since="1.0.21", status=API.Status.EXPERIMENTAL)
public final class FunctionalInterfaceArbitraryIntrospector
implements ArbitraryIntrospector {
    private static final Map<Class<?>, String> FUNCTIONAL_INVOKE_METHOD_NAMES_BY_ASSIGNABLE_TYPE = new HashMap();
    private static final String INVOKE_METHOD_NAME = "invoke";

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        if (!property.isContainer()) {
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        List<CombinableArbitrary<?>> elementCombinableArbitraryList = context.getElementCombinableArbitraryList();
        int lastElementIndex = elementCombinableArbitraryList.size() - 1;
        CombinableArbitrary<Object> result = elementCombinableArbitraryList.get(lastElementIndex).map(it -> this.toFunctionalInterface(Types.getActualType(context.getResolvedType()), it));
        return new ArbitraryIntrospectorResult(result);
    }

    private <T> Object toFunctionalInterface(Class<?> type, T value) {
        InvocationHandlerBuilder invocationHandlerBuilder = new InvocationHandlerBuilder(type, new HashMap<String, Object>());
        for (Map.Entry<Class<?>, String> entry : FUNCTIONAL_INVOKE_METHOD_NAMES_BY_ASSIGNABLE_TYPE.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            invocationHandlerBuilder.put(entry.getValue(), value);
        }
        if (invocationHandlerBuilder.isEmpty()) {
            invocationHandlerBuilder.put(INVOKE_METHOD_NAME, value);
        }
        return Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, invocationHandlerBuilder.build());
    }

    static {
        FUNCTIONAL_INVOKE_METHOD_NAMES_BY_ASSIGNABLE_TYPE.put(Function.class, "apply");
        FUNCTIONAL_INVOKE_METHOD_NAMES_BY_ASSIGNABLE_TYPE.put(Supplier.class, "get");
    }
}

