/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.ExactTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class IterableIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(IterableIntrospector.class);
    private static final Matcher MATCHER = p -> new ExactTypeMatcher(Iterable.class).match(p);

    @Override
    public boolean match(Property property) {
        return MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        if (!this.match(context.getResolvedProperty())) {
            LOGGER.info("Given type {} is not Iterable type.", (Object)context.getResolvedType());
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        List<CombinableArbitrary<?>> elementCombinableArbitraryList = context.getElementCombinableArbitraryList();
        return new ArbitraryIntrospectorResult(CombinableArbitrary.containerBuilder().elements(elementCombinableArbitraryList).build(ArrayList::new));
    }
}

