/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class MapEntryElementIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapEntryElementIntrospector.class);

    @Override
    public boolean match(Property property) {
        return property.getClass() == MapEntryElementProperty.class;
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        if (!property.isContainer() || !this.match(context.getResolvedProperty())) {
            LOGGER.info("Given type {} is not Map Element.", (Object)context.getResolvedType());
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        List<CombinableArbitrary<?>> elementCombinableArbitraryList = context.getElementCombinableArbitraryList();
        if (elementCombinableArbitraryList.size() != 2) {
            throw new IllegalArgumentException("Key and Value should be exist for MapEntryElementType.");
        }
        ArrayList entryCombinableArbitraryList = new ArrayList();
        CombinableArbitrary<Object> keyCombinableArbitrary = elementCombinableArbitraryList.get(0).filter(context.getGenerateUniqueMaxTries(), obj -> context.isUniqueAndCheck(Objects.requireNonNull(context.getOwnerContext()).getPropertyPath(), obj));
        CombinableArbitrary<?> valueCombinableArbitrary = elementCombinableArbitraryList.get(1);
        entryCombinableArbitraryList.add(keyCombinableArbitrary);
        entryCombinableArbitraryList.add(valueCombinableArbitrary);
        return new ArbitraryIntrospectorResult(CombinableArbitrary.containerBuilder().elements(entryCombinableArbitraryList).build(this::combine));
    }

    private Object combine(List<Object> elements) {
        MapEntryElementProperty.MapEntryElementType elementType = new MapEntryElementProperty.MapEntryElementType();
        elementType.setKey(elements.get(0));
        elementType.setValue(elements.get(1));
        return elementType;
    }
}

